package com.pcloud.book.advertising.dao;

import com.pcloud.book.advertising.dto.AdvertisingSpaceDTO;
import com.pcloud.book.advertising.entity.AdvertisingSpace;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;
import java.util.Map;

/**
 * Description 广告位数据访问层接口
 * @author PENG
 * @date 2019/2/28
 */
public interface AdvertisingSpaceDao extends BaseDao<AdvertisingSpace> {

    /**
     * 获取广告位信息
     * @param adId 广告位ID
     * @return
     */
    AdvertisingSpaceDTO getDTOById(Long adId);

    /**
     * 书刊广告位明细
     * @param paramMap 参数Map
     * @return
     */
    List<AdvertisingSpaceDTO> advertisingDetail4Book(Map<String, Object> paramMap);

    /**
     * 微信群广告位明细
     * @param paramMap 参数Map
     * @return
     */
    List<AdvertisingSpaceDTO> advertisingDetail4WechatGroup(Map<String, Object> paramMap);

    /**
     * 广告主广告位明细
     * @param paramMap 参数Map
     * @return
     */
    List<AdvertisingSpaceDTO> advertisingDetail4Master(Map<String, Object> paramMap);

    /**
     * 获取书刊下的广告位列表
     * @param paramMap 参数Map
     * @return
     */
    List<AdvertisingSpaceDTO> getDTOByBookId(Map<String, Object> paramMap);

    /**
     * 未转码的文件
     * @return
     */
    public List<AdvertisingSpace> getUnConvertFile(String adDetailFileId);

    /**
     * 根据fileId更新
     * @param advertisingSpace
     */
    public void updateByFileId(AdvertisingSpace advertisingSpace);

    /**
     * 更新测试状态
     * @param isTest
     * @param id
     */
    public void updateTestStatus(Boolean isTest, Long id);

    /**
     * 根据id集合获取
     */
    List<AdvertisingSpace> getByIds(List<Long> ids);

    /**
     * 获取广告id列表
     * @param id
     * @return
     */
    List<Long> getAdIdsByMasterId(Long id);

    /**
     * 使用cpa的广告ids
     * @param cpaId
     * @return
     */
    public List<Long> getAdIdsByCPAId(Long cpaId);

    /**
     * 更新cpaId
     * @param adId
     * @param cpaId
     */
    void updateCPAId(Long adId, Long cpaId);

    /**
     * 查询cpa方式的广告位,没有cpaid
     * @return
     */
    public List<AdvertisingSpace> getCPASpaceList();
}
