package com.pcloud.book.advertising.dao;

import com.pcloud.book.advertising.dto.BmRegisterDTO;
import com.pcloud.book.advertising.entity.AdvertisingBmRegister;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;
import java.util.Map;

/**
 * @描述：报名记录
 * @作者：zhuyajie
 * @创建时间：20:06 2019/6/27
 * @版本：1.0
 */
public interface BmRegisterDao extends BaseDao<AdvertisingBmRegister> {

    /**
     * 获取用户报名信息
     * @param paramMap
     * @return
     */
    List<BmRegisterDTO> getDetailByUser(Map<String, Object> paramMap);

    /**
     * 获取报名数量
     * @param adId
     * @return
     */
    public Long getRegisterCountByAdId(Long adId, String statisMonth, Long bookId, Long adviserId, Long channelId);;

    /**
     * 报名数量
     * @param adIdList
     * @return
     */
    Long getRegisterCountByAdIds(List<Long> adIdList);

    /**
     * 获取微信群报名次数
     * @param adId
     * @param statisMonth
     * @param qrcodeId
     * @return
     */
    Long getRegisterCountByAdIdQrcodeId(Long adId, String statisMonth, Long qrcodeId);

    /**
     * 获取微信群报名人数
     * @param qrcodeId
     * @param adId
     * @param statisMonth
     * @return
     */
    Long getRegisterUserNumByAdIdQrcodeId(Long qrcodeId, Long adId, String statisMonth);

    /**
     * 查微信群报名用户信息
     * @param adId
     * @param statisMonth
     * @param qrcodeId
     * @return
     */
    List<BmRegisterDTO> getRegisterInfoListByAdIdQrcodeId(Long adId, String statisMonth, Long qrcodeId);

    /**
     * 查报名用户信息
     * @param adId
     * @param statisMonth
     * @param bookId
     * @param adviserId
     * @param channelId
     * @return
     */
    List<BmRegisterDTO> getRegisterInfoListByAdId(Long adId, String statisMonth, Long bookId, Long adviserId, Long channelId);

    /**
     * 获取书刊报名次数
     * @param bookId
     * @param adviserId
     * @param channelId
     * @return
     */
    public Long getRegisterCountByBookId(Long bookId, Long adviserId, Long channelId, Long adId, String statisMonth);
}
