package com.pcloud.book.advertising.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.dto.BaseDto;

import java.util.Date;

/**
 * @描述：品牌方标记书刊列表
 * @作者：zhuyajie
 * @创建时间：11:51 2019/8/22
 * @版本：1.0
 */
public class Book4AdvertisingTagDTO extends BaseDto {

    /**
     * 书籍标识
     */
    private Long bookId;

    /**
     * 书籍ISBN码
     */
    private String isbn;
    /**
     * 书籍名称
     */
    private String bookName;
    /**
     * 创建日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;
    /**
     * 微信群数量
     */
    private Integer groupCount;
    /**
     * 群总人数
     */
    private Integer groupUserNum;

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public String getIsbn() {
        return isbn;
    }

    public void setIsbn(String isbn) {
        this.isbn = isbn;
    }

    public String getBookName() {
        return bookName;
    }

    public void setBookName(String bookName) {
        this.bookName = bookName;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Integer getGroupCount() {
        return groupCount;
    }

    public void setGroupCount(Integer groupCount) {
        this.groupCount = groupCount;
    }

    public Integer getGroupUserNum() {
        return groupUserNum;
    }

    public void setGroupUserNum(Integer groupUserNum) {
        this.groupUserNum = groupUserNum;
    }

    @Override
    public String toString() {
        return "Book4AdvertisingMasterDTO{" +
                "bookId=" + bookId +
                ", isbn='" + isbn + '\'' +
                ", bookName='" + bookName + '\'' +
                ", createTime=" + createTime +
                ", groupCount=" + groupCount +
                ", groupUserNum=" + groupUserNum +
                '}';
    }
}
