package com.pcloud.book.appeal.dao;

import java.util.List;

import com.pcloud.book.appeal.dto.BookAppealDto;
import com.pcloud.book.appeal.entity.BookAppeal;
import com.pcloud.common.core.dao.BaseDao;

/**
 * 书刊申诉数据访问层接口
 * 
 * @author:lili
 * @date 创建时间：2017年3月30日 下午4:16:20
 * @version 1.0
 * @return
 */
public interface BookAppealDao extends BaseDao<BookAppeal> {

	/**
	 * 获取申诉详情
	 * 
	 * @param bookAppealId
	 *            书刊申诉标识
	 * @return
	 */
	BookAppealDto getById(Long bookAppealId);

	/**
	 * 
	 * @param bookAppealId
	 *            书刊申诉标识
	 * @return: List<BookAppealDto>
	 */
	List<BookAppealDto> getAppealAdvisers(Long bookAppealId);
}
