package com.pcloud.book.applet.biz;

import com.pcloud.book.applet.dto.AddBookParamDTO;
import com.pcloud.book.applet.dto.AppletBooklistClassifyDTO;
import com.pcloud.book.applet.dto.AppletBooklistDTO;
import com.pcloud.book.applet.dto.AppletOuterBookDTO;
import com.pcloud.book.applet.dto.AppletOuterBooklistDTO;
import com.pcloud.book.applet.dto.BookDTO4Booklist;
import com.pcloud.book.applet.dto.ServeCollectDTO;
import com.pcloud.book.applet.entity.AppletBooklist;
import com.pcloud.book.applet.entity.AppletBooklistClassify;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;
import java.util.Map;

/**
 * 小程序书单
 */
public interface AppletBooklistBiz {

    /**
     * 新增书单栏目
     * @param appletBooklistClassify
     */
    Long addBooklistClassify(AppletBooklistClassify appletBooklistClassify);

    /**
     * 删除书单栏目
     * @param id
     */
    void deleteBooklistClassifyById(Long id);

    /**
     * 修改书单栏目
     * @param appletBooklistClassify
     */
    void updateBooklistClassify(AppletBooklistClassify appletBooklistClassify);

    /**
     * 书单栏目列表
     * @param currentPage
     * @param numPerPage
     * @return
     */
    PageBeanNew<AppletBooklistClassifyDTO> listBooklistClassify(Integer currentPage, Integer numPerPage, String name, Long agentId);

    /**
     * 新增书单
     * @param appletBooklist
     * @return
     */
    Long addBooklist(AppletBooklist appletBooklist);

    /**
     * 删除书单
     * @param id
     */
    void deleteBooklistById(Long id);

    /**
     * 修改书单
     * @param appletBooklist
     */
    void updateBooklist(AppletBooklist appletBooklist);

    /**
     * 根据id查书单
     */
    AppletBooklistDTO getBooklistById(Long id);

    /**
     * 书单管理列表
     * @param currentPage
     * @param numPerPage
     * @return
     */
    PageBeanNew<AppletBooklistDTO> listBooklist(Integer currentPage, Integer numPerPage, String name, Long classifyId, Long agentId,
                                                Long firstClassify,Long secondClassify,Long thirdClassify, Long gradeLabelId, Long subjectLabelId, Long relateAgentId);

    /**
     * 书单添加图书
     * @param addBookParamDTO
     */
    void addBookToBooklist(AddBookParamDTO addBookParamDTO);

    /**
     *获取书单下书籍列表
     * @param booklistId
     * @param currentPage
     * @param numPerPage
     * @return
     */
    PageBeanNew<BookDTO4Booklist> listPageBook4AppletBooklist(Long booklistId, Integer currentPage, Integer numPerPage);
    /**
     * 更新书籍排序
     * @param configId
     * @param seq
     */
    void updateBookSeq(Long configId, Integer seq);

    /**
     * 获取所有书单栏目
     * @return
     */
    List<AppletBooklistClassifyDTO> getAllBooklistClassify(Boolean showState, Long agentId);

    /**
     * 客户端获取书单列表
     * @param classifyId
     * @param currentPage
     * @param numPerPage
     * @return
     */
    PageBeanNew<AppletBooklistDTO> listBooklist4Wechat(Long classifyId, Integer currentPage, Integer numPerPage, Long wechatUserId, Long officialAccountsId);

    /**
     * 客户端根据id获取书单
     * @param booklistId
     * @return
     */
    AppletBooklistDTO getBooklistById4Wechat(Long booklistId);

    /**
     * 图书详情-出版作者分类书名
     * @param adviserId
     * @param channelId
     * @param bookId
     * @return
     */
    BookDTO4Booklist getByBookIdAdviserChannel(Long adviserId, Long channelId, Long bookId);

    /**
     * 用户选择书单栏目
     * @author：zhuyajie
     * @date：2020/5/14 11:21
     *  * @param null
     */
    void addUserBooklistClassify(List<Long> classifyIds, Long wechatUserId, Long officialAccountsId);
    /**
     * 所有书单栏目列表+用户选择的书单栏目
     * @author：zhuyajie
     * @date：2020/5/14 11:21
     *  * @param null
     */
    List<AppletBooklistClassifyDTO> getAllBooklistClassify4Wechat(Long wechatUserId, Long officialAccountsId);
    /**
     * 用户选择的书单栏目
     * @author：zhuyajie
     * @date：2020/5/14 11:21
     *  * @param null
     */
    List<AppletBooklistClassifyDTO> getBooklistClassifyByUser(Long wechatUserId, Long officialAccountsId);

    /**
     * 添加默认书单推荐栏目
     * @author：zhuyajie
     * @date：2020/8/5 10:59
     *  * @param null
     */
    void addDefaultBooklistClassify(Long agentId);
    /**
     * 添加外部书刊
     * @author：zhuyajie
     * @date：2020/8/11 11:57
     *  * @param null
     */
    Long addOuterBook(AppletOuterBookDTO appletOuterBookDTO);

    /**
     * 根据id查外部书刊
     * @author：zhuyajie
     * @date：2020/8/11 12:00
     *  * @param null
     */
    AppletOuterBookDTO getOuterBookById(Long outerBookId);

    /**
     * 外部书刊分页查询
     * @author：zhuyajie
     * @date：2020/8/11 12:02
     *  * @param null
     */
    PageBeanNew<AppletOuterBookDTO> listPageOuterBook(Integer currentPage, Integer numPerPage, String publish,
                                                      String name, Long agentId);
    /**
     * 外部书刊出版社列表
     * @author：zhuyajie
     * @date：2020/8/11 13:53
     *  * @param null
     */
    List<String> getOuterBookPublish(Long agentId);
    /**
     * 删除外部书刊
     * @author：zhuyajie
     * @date：2020/8/11 13:53
     *  * @param null
     */
    void deleteOuterBookById(Long id);
    /**
     * 创建外部书单
     * @author：zhuyajie
     * @date：2020/8/11 14:48
     *  * @param null
     */
    Long addOuterBooklist(AppletOuterBooklistDTO appletOuterBooklistDTO);

    /**
     * 外部书单查询
     * @author：zhuyajie
     * @date：2020/8/11 15:15
     *  * @param null
     */
    AppletOuterBooklistDTO getOuterBooklistById(Long booklistId);
    /**
     * 外部书单列表
     * @author：zhuyajie
     * @date：2020/8/11 15:15
     *  * @param null
     */
    PageBeanNew<AppletOuterBooklistDTO> listPageOuterBooklist(Integer currentPage, Integer numPerPage, String publish,
                                                              String name, Long agentId);
    /**
     * 外部书单出版社列表
     * @author：zhuyajie
     * @date：2020/8/11 15:16
     *  * @param null
     */
    List<String> getOuterBooklistPublish(Long agentId);
    /**
     * 删除外部书单
     * @author：zhuyajie
     * @date：2020/8/11 15:17
     *  * @param null
     */
    void deleteOuterBooklistById(Long id);

    /**
     * 客户端查询外部书单
     * @author：zhuyajie
     * @date：2020/8/11 16:33
     *  * @param null
     */
    AppletOuterBooklistDTO getOutBooklistById4Wechat(Long booklistId);

    /**
     * 批量查外部书单
     * @author：zhuyajie
     * @date：2020/8/11 17:07
     *  * @param null
     */
    Map<Long,AppletOuterBooklistDTO> getByIds(List<Long> booklistIds);

    /**
     * 批量从外部书单中移出书刊
     * @author：zhuyajie
     * @date：2020/8/12 17:28
     *  * @param null
     */
    void batchDeleteOuterBookFromBooklist(List<Long> configIds);
    /**
     * 根据书单id查外部书刊分页查询
     * @author：zhuyajie
     * @date：2020/8/12 17:28
     *  * @param null
     */
    PageBeanNew<AppletOuterBookDTO> listPageOuterBookByBooklistId(Integer currentPage, Integer numPerPage, Long booklistId);


    /**
     * 根据书刊查询推荐书单列表
     * @author：zhuyajie
     * @date：2020/8/10 10:24
     *  * @param null
     */
    List<AppletBooklistDTO> getRecommendBooklistByBook(Long bookId, Long adviserId, Long channelId);

    /**
     * 根据书刊分类自动创建书单
     * @author：zhuyajie
     * @date：2020/8/28 19:22
     *  * @param null
     */
    void autoCreateBooklistByTemplet(Long firstClassify);

    /**
     * 获取小程序精选书单
     * @param bookListIds
     * @return
     */
    Map<Long, AppletBooklistDTO> getBookListMap(List<Long> bookListIds);

    /**
     * 更新外部书单推荐到首页状态
     * @param appletOuterBooklistDTO
     */
    void updateOuterBooklist(AppletOuterBooklistDTO appletOuterBooklistDTO);

    /**
     * 客户端获取外部书单列表
     * @param currentPage
     * @param numPerPage
     * @return
     */
    PageBeanNew<AppletOuterBooklistDTO> listPageOuterBooklist4Wechat(Integer currentPage, Integer numPerPage);

    /**
     * 批量查外部书单(不含书籍)
     * @author：zhuyajie
     * @date：2020/8/11 17:07
     *  * @param null
     */
    Map<Long,AppletOuterBooklistDTO> getBooklistInfoByIds(List<Long> booklistIds);
}
