package com.pcloud.book.applet.biz.impl;

import com.pcloud.book.applet.biz.AppletRecordDayServeBiz;
import com.pcloud.book.applet.dao.AppletRecordDayServeDao;
import com.pcloud.book.applet.entity.AppletRecordDayServe;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.NumberUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * (AppletRecordDayServe)表服务实现类
 *
 * @author makejava
 * @since 2020-12-09 16:04:08
 */
@Service("appletRecordDayServeBiz")
public class AppletRecordDayServeBizImpl implements AppletRecordDayServeBiz {

    private static final Logger LOGGER = LoggerFactory.getLogger(AppletRecordDayServeBizImpl.class);

    @Autowired
    private AppletRecordDayServeDao appletRecordDayServeDao;

    @Override
    @ParamLog("通过ID查询单条数据")
    public AppletRecordDayServe getById(Long id) {
        return appletRecordDayServeDao.getById(id);
    }

    @Override
    @ParamLog("查询多条数据")
    public PageBeanNew getList(Integer currentPage, Integer numPerPage) {
        PageBeanNew pageBeanNew = appletRecordDayServeDao.listPageNew(new PageParam(currentPage, numPerPage), null, "getList");
        List recordList = pageBeanNew.getRecordList();
        if (ListUtils.isEmpty(recordList)) {
            return pageBeanNew;
        }
        // 加载其它数据

        return pageBeanNew;
    }

    @Override
    @ParamLog("新增")
    public Long insert(AppletRecordDayServe appletRecordDayServe) {
        appletRecordDayServeDao.insert(appletRecordDayServe);
        return appletRecordDayServe.getId();
    }

    @Override
    @ParamLog("修改")
    public void update(AppletRecordDayServe appletRecordDayServe) {
        if (appletRecordDayServe == null || !NumberUtil.isNumber(appletRecordDayServe.getId())) {
            throw BizException.PARAM_IS_NULL;
        }
        appletRecordDayServeDao.update(appletRecordDayServe);
    }

    @Override
    @ParamLog("删除")
    public void deleteById(Long id) {
        appletRecordDayServeDao.deleteById(id);
    }
}