package com.pcloud.book.applet.biz.impl;

import com.pcloud.book.applet.biz.BuyBookRequestReplyBiz;
import com.pcloud.book.applet.dao.BuyBookRequestDao;
import com.pcloud.book.applet.dao.BuyBookRequestReplyDao;
import com.pcloud.book.applet.dto.BuyBookRequestReplyDTO;
import com.pcloud.book.applet.entity.BuyBookRequest;
import com.pcloud.book.applet.entity.BuyBookRequestReply;
import com.pcloud.common.exceptions.BizException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service("buyBookRequestReplyBiz")
public class BuyBookRequestReplyBizImpl implements BuyBookRequestReplyBiz {

    @Autowired
    private BuyBookRequestReplyDao buyBookRequestReplyDao;

    @Autowired
    private BuyBookRequestDao buyBookRequestDao;

    @Override
    public Long insert(BuyBookRequestReply buyBookRequestReply) {
        //回复消息后，将购书记录更改为已回复状态.
        Long requestId = buyBookRequestReply.getRequestId();
        BuyBookRequest buyBookRequest = new BuyBookRequest();
        buyBookRequest.setId(requestId);
        buyBookRequest.setReplyState(1);
        buyBookRequestDao.update(buyBookRequest);
        return buyBookRequestReplyDao.insert(buyBookRequestReply);
    }

    @Override
    public List<BuyBookRequestReplyDTO> getByRequestId(Long requestId) {
        return buyBookRequestReplyDao.getByRequestId(requestId);
    }

    @Override
    public void deleteById(Long id) {
        if (null == id ){
            throw BizException.PARAM_IS_NULL;
        }
        buyBookRequestReplyDao.deleteById(id);
    }

    @Override
    public List<BuyBookRequestReplyDTO> getListByIds(List<Long> requestIds) throws BizException {
        return buyBookRequestReplyDao.getListByIds(requestIds);
    }
}
