package com.pcloud.book.applet.dao.impl;

import com.pcloud.book.applet.dao.AppletNewsDao;
import com.pcloud.book.applet.dto.AppletNewsCustomTagDTO;
import com.pcloud.book.applet.dto.AppletNewsDTO;
import com.pcloud.book.applet.entity.AppletNews;
import com.pcloud.book.applet.entity.AppletNewsCustomTag;
import com.pcloud.book.applet.vo.AppletNewsClassifyVO;
import com.pcloud.book.applet.vo.AppletNewsShowStateVO;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 小程序资讯
 */
@Component
public class AppletNewsDaoImpl extends BaseDaoImpl<AppletNews> implements AppletNewsDao {

    /**
     * 根据名片id获取是否已经绑定微信
     * @param businessCardId
     * @return
     */
    public Long getCountByBusinessCardId(Long businessCardId){
        return getSessionTemplate().selectOne(getStatement("getCountByBusinessCardId"), businessCardId);
    }

    @Override
    public List<AppletNews> getByNewsClassifyId(Long newsClassifyId) {
        return getSessionTemplate().selectList(getStatement("getByNewsClassifyId"), newsClassifyId);
    }

    @Override
    public void updateNewsShowState(AppletNews appletNews) {
        getSessionTemplate().update(getStatement("updateNewsShowState"),appletNews);
    }

    @Override
    public List<AppletNewsDTO> getByNewsByTempletLabel(Long firstClassify, Long secondClassify, Long gradeLabelId, Long subjectLabelId, String rightsType, Long agentId, Long thirdClassify) {
        Map<String,Object> map = new HashMap<>();
        map.put("firstClassify", firstClassify);
        map.put("secondClassify", secondClassify);
        map.put("thirdClassify", thirdClassify);
        map.put("gradeLabelId",gradeLabelId);
        map.put("subjectLabelId", subjectLabelId);
        map.put("rightsType",rightsType);
        if (null == agentId){
            agentId = 0L;
        }
        map.put("agentId", agentId);
        return getSessionTemplate().selectList(getStatement("getByNewsByTempletLabel"),map);

    }

    @Override
    public List<AppletNews> getByTempletAndClassify(Long firstClassify, Long secondClassify, Long gradeLabelId, Long subjectLabelId, Long rightsClassifyId, Integer top,
                                                    Long agentId, Long thirdClassify) {
        Map<String,Object> map = new HashMap<>();
        map.put("firstClassify", firstClassify);
        map.put("secondClassify", secondClassify);
        map.put("thirdClassify", thirdClassify);
        map.put("gradeLabelId",gradeLabelId);
        map.put("subjectLabelId", subjectLabelId);
        map.put("rightsClassifyId",rightsClassifyId);
        map.put("top", top);
        if (null == agentId){
            agentId = 0L;
        }
        map.put("agentId", agentId);
        return getSessionTemplate().selectList(getStatement("getByTempletAndClassify"),map);
    }

    @Override
    public void insertSource(String source, Long agentId) {
        if (null == agentId) {
            agentId = 0L;
        }
        Map<String, Object> map = new HashMap<>();
        map.put("agentId", agentId);
        map.put("source", source);
        getSessionTemplate().insert(getStatement("insertSource"), map);
    }

    @Override
    public List<String> getNewsSourceList(Long agentId) {
        Map<String,Object>map = new HashMap<>();
        map.put("agentId", agentId);
        return getSessionTemplate().selectList(getStatement("getNewsSourceList"), map);
    }

    @Override
    public Integer getAppletNewsSourceCount(String source, Long agentId) {
        Map<String,Object>map = new HashMap<>();
        map.put("agentId", agentId);
        map.put("source", source);
        return getSessionTemplate().selectOne(getStatement("getAppletNewsSourceCount"), map);
    }

    @Override
    public void deleteSource(String source, Long agentId) {
        if (null == agentId){
            agentId = 0L;
        }
        Map<String,Object>map = new HashMap<>();
        map.put("agentId", agentId);
        map.put("source", source);
        getSessionTemplate().delete(getStatement("deleteSource"), map);
    }

    @Override
    public Boolean newsSourceExist(String source, Long agentId) {
        Map<String,Object>map = new HashMap<>();
        map.put("agentId", agentId);
        map.put("source", source);
        return getSessionTemplate().selectOne(getStatement("newsSourceExist"), map);
    }

    @Override
    public void batchUpdateClassify(AppletNewsClassifyVO appletNewsClassifyVO) {
        Map<String,Object> map = new HashMap<>();
        map.put("ids", appletNewsClassifyVO.getAppletNewsIds());
        map.put("firstClassify", appletNewsClassifyVO.getFirstClassify());
        map.put("secondClassify", appletNewsClassifyVO.getSecondClassify());
        map.put("thirdClassify", appletNewsClassifyVO.getThirdClassify());
        map.put("gradeLabelId", appletNewsClassifyVO.getGradeLabelId());
        map.put("subjectLabelId", appletNewsClassifyVO.getSubjectLabelId());
        map.put("rightsClassifyId", appletNewsClassifyVO.getRightsClassifyId());
        map.put("newsClassifyId", appletNewsClassifyVO.getNewsClassifyId());
        map.put("cityCode", appletNewsClassifyVO.getCityCode());
        getSessionTemplate().update(getStatement("batchUpdateClassify"), map);
    }

    @Override
    public void batchUpdateShowState(AppletNewsShowStateVO appletNewsShowStateVO) {
        Map<String,Object> map = new HashMap<>();
        map.put("ids", appletNewsShowStateVO.getAppletNewsIds());
        map.put("showState", appletNewsShowStateVO.getShowState());
        getSessionTemplate().update(getStatement("batchUpdateShowState"), map);
    }

    @Override
    public void batchDeleteAppletNews(List<Long> list) {
        getSessionTemplate().delete(getStatement("batchDeleteAppletNews"), list);
    }

    @Override
    public String getUrlNumberByJumpUrl(String jumpUrl, Long agentId) {
        if (null == agentId){
            agentId = 0L;
        }
        Map<String, Object> map = new HashMap<>();
        map.put("jumpUrl", jumpUrl);
        map.put("agentId", agentId);
        return getSessionTemplate().selectOne(getStatement("getUrlNumberByJumpUrl"), jumpUrl);
    }

    @Override
    public Boolean urlNumberExist(String urlNumber, Long id, Long agentId) {
        Map<String, Object> map = new HashMap<>();
        map.put("urlNumber", urlNumber);
        map.put("id", id);
        map.put("agentId", agentId);
        return getSessionTemplate().selectOne(getStatement("urlNumberExist"), map);
    }

    @Override
    public Map<Long, AppletNewsDTO> getByIds(List<Long> list) {
        return this.getSqlSession().selectMap(getStatement("getByIds"), list, "id");
    }

    @Override
    public void batchUpdateNewsClassify(AppletNewsClassifyVO appletNewsClassifyVO) {
        Map<String,Object> map = new HashMap<>();
        map.put("ids", appletNewsClassifyVO.getAppletNewsIds());
        map.put("newsClassifyId", appletNewsClassifyVO.getNewsClassifyId());
        getSessionTemplate().update(getStatement("batchUpdateNewsClassify"), map);
    }

    @Override
    public void batchUpdateCustomTagId(List<Long> ids, Long customTagId) {
        Map<String, Object> map = new HashMap<>();
        map.put("ids", ids);
        map.put("customTagId", customTagId);
        getSessionTemplate().update(getStatement("batchUpdateCustomTagId"), map);
    }

    @Override
    public void insertCustomTag(AppletNewsCustomTag appletNewsCustomTag) {
        getSessionTemplate().insert(getStatement("insertCustomTag"), appletNewsCustomTag);
    }

    @Override
    public void updateCustomTag(AppletNewsCustomTag appletNewsCustomTag) {
        getSessionTemplate().update(getStatement("updateCustomTag"), appletNewsCustomTag);
    }

    @Override
    public List<AppletNewsCustomTagDTO> getCustomTagList(Long agentId) {
        Map<String,Object> map = new HashMap<>();
        map.put("agentId", agentId);
        return getSessionTemplate().selectList(getStatement("getCustomTagList"), map);
    }

    @Override
    public Boolean customTagExist(String customTag, Long agentId) {
        Map<String,Object> map = new HashMap<>();
        map.put("customTag", customTag);
        map.put("agentId", agentId);
        return getSessionTemplate().selectOne(getStatement("customTagExist"), map);
    }

    @Override
    public List<Long> getNewsIdListByCustomTagId(Long customTagId) {
        return getSessionTemplate().selectList(getStatement("getNewsIdListByCustomTagId"), customTagId);
    }

    @Override
    public void batchUpdateCardShowState(AppletNewsShowStateVO appletNewsShowStateVO) {
        Map<String,Object> map = new HashMap<>();
        map.put("ids", appletNewsShowStateVO.getAppletNewsIds());
        map.put("businessCardIsOpen", appletNewsShowStateVO.getBusinessCardIsOpen());
        getSessionTemplate().update(getStatement("batchUpdateCardShowState"), map);
    }

    @Override
    public void updateCardShowState(AppletNews appletNews) {
        getSessionTemplate().update(getStatement("updateCardShowState"),appletNews);
    }

    @Override
    public List<AppletNewsDTO> listNewsByCityCode(String cityId) {
        return this.getSqlSession().selectList(getStatement("listNewsByCityCode"), cityId);
    }

    @Override
    public void deleteByNews(List<Long> newsIds) {
        getSessionTemplate().update(getStatement("deleteByNews"), newsIds);
    }

    @Override
    public Map<Long, AppletNewsDTO> getByIds4Record(List<Long> newsIds) {
        return this.getSqlSession().selectMap(getStatement("getByIds4Record"), newsIds, "id");
    }

    @Override
    public Integer listAppletNews4WechatCount(Map<String, Object> paramMap) {
        return getSessionTemplate().selectOne(getStatement("listAppletNews4WechatCount"), paramMap);
    }

}
