package com.pcloud.book.applet.dao.impl;

import com.pcloud.book.applet.dao.AppletNewsPoolDAO;
import com.pcloud.book.applet.entity.AppletNewsPool;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

@Repository
public class AppletNewsPoolDAOImpl extends BaseDaoImpl<AppletNewsPool> implements AppletNewsPoolDAO {
    @Override
    public void updateSelective(AppletNewsPool appletNewsPool) {
        getSessionTemplate().update(getStatement("updateSelective"), appletNewsPool);
    }

    @Override
    public void batchDelete(List<Long> ids) {
        getSessionTemplate().delete(getStatement("batchDelete"), ids);
    }

    @Override
    public List<String> listSource() {
        return getSessionTemplate().selectList(getStatement("listSource"));
    }

    @Override
    public Map<Long, AppletNewsPool> getMapByIds(List<Long> appletNewsPoolIds) {
        return getSessionTemplate().selectMap(getStatement("getMapByIds"), appletNewsPoolIds, "id");
    }
}
