package com.pcloud.book.applet.dao.impl;

import com.pcloud.book.applet.entity.AppletRecordStatisReport;
import com.pcloud.book.applet.dao.AppletRecordStatisReportDao;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;
import org.apache.ibatis.annotations.Param;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.HashMap;
import java.util.List;

/**
 * 个人阅读报告总结(AppletRecordStatisReport)表数据库访问层
 *
 * @author makejava
 * @since 2020-12-11 16:22:46
 */
@Repository("appletRecordStatisReportDaoImpl")
public class AppletRecordStatisReportDaoImpl extends BaseDaoImpl<AppletRecordStatisReport> implements AppletRecordStatisReportDao {
    @Override
    public AppletRecordStatisReport getByWechatUserId(Long wechatUserId, Date beginDate) {
        HashMap<String, Object> paramMap = new HashMap<>();
        paramMap.put("wechatUserId", wechatUserId);
        paramMap.put("beginDate", beginDate);
        return this.sqlSessionTemplate.selectOne(getStatement("getByWechatUserId"), paramMap);
    }

    @Override
    public List<AppletRecordStatisReport> getUserHistoryReport(Long wechatUserId, List<Date> allMonday) {
        HashMap<String, Object> paramMap = new HashMap<>();
        paramMap.put("wechatUserId", wechatUserId);
        paramMap.put("allMonday", allMonday);
        return this.sqlSessionTemplate.selectList(getStatement("getUserHistoryReport"), paramMap);
    }

    @Override
    public void insertOrUpdate(List<AppletRecordStatisReport> historyReportList) {
        if(CollectionUtils.isEmpty(historyReportList)){
            return;
        }
        this.sqlSessionTemplate.insert(getStatement("insertOrUpdate"), historyReportList);
    }

    @Override
    public AppletRecordStatisReport getFirstStatisReport(Long wechatUserId) {
        HashMap<String, Object> paramMap = new HashMap<>();
        paramMap.put("wechatUserId", wechatUserId);
        return this.sqlSessionTemplate.selectOne(getStatement("getFirstStatisReport"), paramMap);
    }
}
