package com.pcloud.book.applet.dao.impl;

import com.pcloud.book.applet.dao.BuyBookRequestReplyDao;
import com.pcloud.book.applet.dto.BuyBookRequestReplyDTO;
import com.pcloud.book.applet.entity.BuyBookRequestReply;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * (BuyBookRequestReply)表数据库访问层
 *
 * @author dominic_Z
 * @since 2020年12月25日 14:51:00
 */
@Repository("buyBookRequestReplyDaoImpl")
public class BuyBookRequestReplyDaoImpl extends BaseDaoImpl<BuyBookRequestReply> implements BuyBookRequestReplyDao {

    @Override
    public List<BuyBookRequestReplyDTO> getByRequestId(Long requestId) {
        return getSessionTemplate().selectList("getByRequestId", requestId);
    }

    @Override
    public List<BuyBookRequestReplyDTO> getListByIds(List<Long> requestIds) {
        return getSessionTemplate().selectList(getStatement("listBaseMapByIds"),requestIds);
    }
}
