package com.pcloud.book.applet.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

@Data
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ReadBookDayStatisDTO {

    private Long wechatUserId;

    @ApiModelProperty("当天读书本数")
    private Integer readBookCount;

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date createDate;

    @ApiModelProperty("周几")
    private String dayOfWeek;

}
