package com.pcloud.book.applet.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;

import java.util.Date;

import javax.validation.constraints.NotNull;

import lombok.Data;

/**
 * 小程序资讯/券库点击埋点(AppletLinkClick)实体类
 *
 * @author makejava
 * @since 2020-05-11 11:41:33
 */
@Data
public class AppletLinkClick extends BaseEntity {
    private static final long serialVersionUID = 452524180857423480L;

    /**
    * 用户id
    */
    @NotNull
    private Long wechatUserId;
    /**
    * 1资讯/2 券库
    */
    @NotNull
    private Integer typeId;
    /**
    * 业务id
    */
    @NotNull
    private Long fromId;
    /**
     * 业务id
     */
    @NotNull
    private Integer recordType;
    /**
    * 创建时间
    */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date createTime;




}