package com.pcloud.book.applet.facade;

import com.pcloud.book.applet.biz.AppletBusinessCardBiz;
import com.pcloud.book.applet.entity.AppletBusinessCard;
import com.pcloud.book.applet.entity.AppletNewsServe;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 *
 * @author
 * @since
 */
@RestController("appletBusinessCardFacade")
@RequestMapping("appletBusinessCard")
public class AppletBusinessCardFacade {
    
    @Autowired
    private AppletBusinessCardBiz appletBusinessCardBiz;

    @ApiOperation("分页查询")
    @GetMapping("getList")
    public ResponseDto<?> getList(@RequestHeader("token") String token,
                                  @RequestParam(value = "keyword", required = false)  String keyword,
                                  @RequestParam(value = "currentPage", defaultValue = "0") Integer currentPage,
                                  @RequestParam(value = "numPerPage", defaultValue = "10") Integer numPerPage)
            throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(appletBusinessCardBiz.getList(keyword,currentPage, numPerPage));
    }
    
    @ApiOperation("新增")
    @PostMapping("insert")
    public ResponseDto<?> insert(@RequestHeader("token") String token, @RequestBody AppletBusinessCard appletBusinessCard)
            throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        return new  ResponseDto<>(appletBusinessCardBiz.insert(appletBusinessCard));
    }

    @ApiOperation("更新")
    @PostMapping("update")
    public ResponseDto<?> update(@RequestHeader("token") String token,@RequestBody AppletBusinessCard appletBusinessCard) throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        appletBusinessCardBiz.update(appletBusinessCard);
        return new ResponseDto<>();
    }
    
    @ApiOperation("删除")
    @GetMapping("deleteById")
    public ResponseDto<?> deleteById(@RequestHeader("token") String token, @RequestParam Long id) throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        if (null == id) {
            throw BookBizException.PARAM_DELETION;
        }
        appletBusinessCardBiz.deleteById(id);
        return new ResponseDto<>();
    }

}