package com.pcloud.book.applet.facade;

import com.pcloud.book.applet.biz.AppletGroupSearchRecordBiz;
import com.pcloud.book.applet.dto.AddAppletGroupDTO;
import com.pcloud.book.applet.dto.UpdateAppletGroupManageDTO;
import com.pcloud.book.applet.biz.AppletGroupManageBiz;
import com.pcloud.book.applet.entity.AppletGroupSearchRecord;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.NumberUtil;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.cookie.Cookie;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import io.swagger.annotations.ApiOperation;

import java.util.List;
import java.util.Map;

/**
 * 学舍群管理(AppletGroupManage)表控制层
 *
 * @author zyq
 * @since 2020-04-01 14:05:42
 */
@Api("小睿学舍群管理")
@RestController("appletGroupManageFacade")
@RequestMapping("appletGroupManage")
public class AppletGroupManageFacade {
    
    @Autowired
    private AppletGroupManageBiz appletGroupManageBiz;
    @Autowired
    private AppletGroupSearchRecordBiz appletGroupSearchRecordBiz;

    @ApiOperation("社群任意门")
    @GetMapping("getList")
    public ResponseDto<?> getList(@RequestHeader("token") String token,
                                  @RequestParam(value = "name", required = false) String name,
                                  @RequestParam(value = "currentPage", defaultValue = "0") Integer currentPage, 
                                  @RequestParam(value = "numPerPage", defaultValue = "10") Integer numPerPage)
            throws BizException, PermissionException {
        Map<String, Object> map = SessionUtil.getToken4Redis(token);
        Long agentId = (Long) map.get(SessionUtil.RAY_AGENT_ID);
        return new ResponseDto<>(appletGroupManageBiz.getList(name, currentPage, numPerPage, agentId));
    }

    @ApiOperation("社群任意门Applet")
    @GetMapping("getList4Applet")
    public ResponseDto<?> getList4Applet(@CookieValue("userInfo") String userInfo,
                                         @RequestParam(value = "recommend", required = false) Integer recommend,
                                         @RequestParam(value = "currentPage", defaultValue = "0") Integer currentPage,
                                         @RequestParam(value = "numPerPage", defaultValue = "5") Integer numPerPage)
            throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        Long officialAccountsId = Cookie.getId(userInfo, Cookie._OFFICIAL_ACCOUNTS_ID);
        if(!NumberUtil.isNumber(wechatUserId)){
            throw BookBizException.PARAM_DELETION;
        }
        return new ResponseDto<>(appletGroupManageBiz.getList4Applet(wechatUserId, recommend, currentPage, numPerPage,officialAccountsId));
    }
    
    @ApiOperation("新增社群")
    @PostMapping("insert")
    public ResponseDto<?> insert(@RequestHeader("token") String token, @RequestBody List<Long> groupActivityIds)
            throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        appletGroupManageBiz.insert(groupActivityIds,0L);
        return new ResponseDto<>();
    }

    @ApiOperation("小睿小程序管理端新增社群")
    @PostMapping("insertByAgent")
    public ResponseDto<?> insertByAgent(@RequestHeader("token") String token, @RequestBody AddAppletGroupDTO addAppletGroupDTO)
            throws BizException, PermissionException {
        Map<String, Object> map = SessionUtil.getToken4Redis(token);
        Long agentId = (Long) map.get(SessionUtil.RAY_AGENT_ID);
        addAppletGroupDTO.setAgentId(agentId);
        if (null == addAppletGroupDTO || ListUtils.isEmpty(addAppletGroupDTO.getGroupActivityIds())
                || null ==addAppletGroupDTO.getAgentId()){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"参数缺失");
        }
        appletGroupManageBiz.insert(addAppletGroupDTO.getGroupActivityIds(), addAppletGroupDTO.getAgentId());
        return new ResponseDto<>();
    }
    
    @ApiOperation("更新上下架、推荐首页")
    @PostMapping("update")
    public ResponseDto<?> update(@RequestHeader("token") String token,@RequestBody UpdateAppletGroupManageDTO UpdateAppletGroupManageDTO) throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        appletGroupManageBiz.update(UpdateAppletGroupManageDTO);
        return new ResponseDto<>();
    }
    
    @ApiOperation("删除社群")
    @GetMapping("deleteById")
    public ResponseDto<?> deleteById(@RequestHeader("token") String token, @RequestParam Long id) throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        if (null == id) {
            throw BookBizException.PARAM_DELETION;
        }
        appletGroupManageBiz.deleteById(id);
        return new ResponseDto<>();
    }

    @ApiOperation("新增社群书搜索记录")
    @PostMapping("insertSearchRecord")
    public ResponseDto<?> insertSearchRecord(@CookieValue("userInfo") String userInfo, @RequestBody AppletGroupSearchRecord appletGroupSearchRecord)
            throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        if(!NumberUtil.isNumber(wechatUserId)){
            throw BookBizException.PARAM_DELETION;
        }
        appletGroupSearchRecord.setWechatUserId(wechatUserId);
        return new ResponseDto<>(appletGroupSearchRecordBiz.insert(appletGroupSearchRecord));
    }

    @ApiOperation("分页查询社群书搜索记录")
    @GetMapping("getSearchRecordList")
    public ResponseDto<?> getSearchRecordList(@CookieValue("userInfo") String userInfo,
                                              @RequestParam(value = "isMore", defaultValue = "0") Integer isMore,
                                              @RequestParam(value = "currentPage", defaultValue = "0") Integer currentPage,
                                              @RequestParam(value = "numPerPage", defaultValue = "10") Integer numPerPage)
            throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        if(!NumberUtil.isNumber(wechatUserId)){
            throw BookBizException.PARAM_DELETION;
        }
        return new ResponseDto<>(appletGroupSearchRecordBiz.getList(wechatUserId, isMore, currentPage, numPerPage, null));
    }

    @ApiOperation("删除共读社群记录")
    @PostMapping("deleteSearchRecordByIds")
    public ResponseDto<?> deleteSearchRecordByIds(@CookieValue("userInfo") String userInfo, @RequestBody List<Long> ids) throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        if(!NumberUtil.isNumber(wechatUserId)){
            throw BookBizException.PARAM_DELETION;
        }
        appletGroupSearchRecordBiz.deleteByIds(ids);
        return new ResponseDto<>();
    }

    @ApiOperation("推荐本书相关学舍列表集合")
    @GetMapping("getTishBookSchoolList")
    public ResponseDto<?> getTishBookSchoolList(@CookieValue("userInfo") String userInfo,
                                              @RequestParam(value = "bookGroupId") Long bookGroupId
                                             )
            throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        Long officialAccountsId = Cookie.getId(userInfo, Cookie._OFFICIAL_ACCOUNTS_ID);
        if(!NumberUtil.isNumber(wechatUserId)){
            throw BookBizException.PARAM_DELETION;
        }
        return new ResponseDto<>(appletGroupSearchRecordBiz.getTishBookSchoolList(wechatUserId, bookGroupId, officialAccountsId));
    }

    @ApiOperation("用户社群书记录id列表")
    @GetMapping("getRecordIdListByUser")
    public ResponseDto<?> getRecordIdListByUser(@CookieValue("userInfo") String userInfo){
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        if(!NumberUtil.isNumber(wechatUserId)){
            throw BookBizException.PARAM_DELETION;
        }
        return new ResponseDto<>(appletGroupSearchRecordBiz.getRecordIdListByUser(wechatUserId));
    }

    @ApiOperation("根据书刊分类查社群--小程序首页")
    @GetMapping("getGroupList4AppletHome")
    public ResponseDto<?> getGroupList4AppletHome(
            @CookieValue("userInfo") String userInfo,
            @RequestParam("numPerPage") Integer numPerPage,
            @RequestParam("currentPage")  Integer currentPage)
            throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        Long officialAccountsId = Cookie.getId(userInfo, Cookie._OFFICIAL_ACCOUNTS_ID);
        if(!NumberUtil.isNumber(wechatUserId)){
            throw BookBizException.PARAM_DELETION;
        }
        return new ResponseDto<>(appletGroupSearchRecordBiz.getGroupList4AppletHome(wechatUserId,currentPage,numPerPage,officialAccountsId));
    }
}