package com.pcloud.book.applet.facade;

import com.pcloud.book.applet.biz.AppletRecordAggrStatisBiz;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.cookie.Cookie;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * (AppletRecordAggrWeekStatis)表控制层
 *
 * @author makejava
 * @since 2020-12-21 10:35:33
 */
@RestController("appletRecordAggrStatisFacade")
@RequestMapping("appletRecordAggrStatis")
public class AppletRecordAggrStatisFacade {
    
    @Autowired
    private AppletRecordAggrStatisBiz appletRecordAggrStatisBiz;

    @ApiOperation("分页查询")
    @GetMapping("getList")
    public ResponseDto<?> getAggrStatis(@CookieValue("userInfo") String userInfo,
                                        @RequestParam(value = "keyword", required = false) String keyword,
                                        @RequestParam(value = "sourceType", defaultValue = "1") Integer sourceType,
                                        @RequestParam(value = "rankType", required = false, defaultValue = "1") Integer rankType,
                                        @RequestParam(value = "currentPage", defaultValue = "0") Integer currentPage,
                                        @RequestParam(value = "numPerPage", defaultValue = "10") Integer numPerPage)
            throws BizException, PermissionException {
        Long wechatUserId = Cookie.getId(userInfo, Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(appletRecordAggrStatisBiz.getAggrStatis(wechatUserId, keyword, sourceType, rankType, currentPage, numPerPage));
    }

}
