package com.pcloud.book.applet.facade;

import com.pcloud.book.applet.biz.SpecialBookBiz;
import com.pcloud.book.applet.dto.SpecialBookDTO;
import com.pcloud.book.applet.dto.ThirdResourceRecordDTO;
import com.pcloud.book.applet.entity.SpecialBook;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.wechatgroup.message.enums.IsSystem;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;

/**
 * (SpecialBook)表控制层
 *
 * @author makejava
 * @since 2020-09-16 13:43:43
 */
@RestController("specialBookFacade")
@RequestMapping("specialBook")
public class SpecialBookFacade {

    @Autowired
    private SpecialBookBiz specialBookBiz;


    @ApiOperation("通过主键查询单条数据")
    @GetMapping("getById")
    public ResponseDto<?> getById(@RequestHeader("token") String token, @RequestParam Long id) throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(specialBookBiz.getById(id));
    }

    @ApiOperation("分页查询")
    @GetMapping("getList")
    public ResponseDto<?> getList(@RequestHeader("token") String token,
                                  @RequestParam(value = "currentPage", defaultValue = "0") Integer currentPage,
                                  @RequestParam(value = "numPerPage", defaultValue = "10") Integer numPerPage)
            throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        return new ResponseDto<>(specialBookBiz.getList(currentPage, numPerPage));
    }

    @ApiOperation("新增")
    @PostMapping("insert")
    public ResponseDto<?> insert(@RequestHeader("token") String token, @RequestBody List<SpecialBook> specialBooks)
            throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        specialBookBiz.insert(specialBooks);
        return new ResponseDto<>();
    }

    @ApiOperation("更新")
    @PostMapping("update")
    public ResponseDto<?> update(@RequestHeader("token") String token, @RequestBody SpecialBook specialBook) throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        specialBookBiz.update(specialBook);
        return new ResponseDto<>();
    }

    @ApiOperation("删除")
    @GetMapping("deleteById")
    public ResponseDto<?> deleteById(@RequestHeader("token") String token, @RequestParam Long id) throws BizException, PermissionException {
        SessionUtil.getToken4Redis(token);
        if (null == id) {
            throw BookBizException.PARAM_DELETION;
        }
        specialBookBiz.deleteById(id);
        return new ResponseDto<>();
    }


    @GetMapping("listSpecialBook")
    public ResponseDto<PageBeanNew<SpecialBookDTO>> listSpecialBook(@RequestHeader("token") String token,
                                                       @RequestParam(value = "queryName",required = false) String queryName,
                                                       @RequestParam(value = "wechatUser",required = false) String wechatUser,
                                                       @RequestParam(value = "startTime", required = false) String startTime,
                                                       @RequestParam(value = "endTime", required = false) String endTime,
                                                       @RequestParam(value = "currentPage", defaultValue = "0") Integer currentPage,
                                                       @RequestParam(value = "numPerPage", defaultValue = "10") Integer numPerPage) {
        SessionUtil.getToken4Redis(token);
        PageBeanNew<SpecialBookDTO> specialBookDTOPageBeanNew = specialBookBiz.listSpecialBook(queryName,startTime, endTime,currentPage, numPerPage, wechatUser);
        return new ResponseDto<>(specialBookDTOPageBeanNew);
    }

    @GetMapping("exportSpecialBook")
    public ResponseDto<Void> exportSpecialBook(@RequestHeader("token") String token,
                                                                    @RequestParam(value = "queryName",required = false) String queryName,
                                                                    @RequestParam(value = "wechatUser",required = false) String wechatUser,
                                                                    @RequestParam(value = "startTime", required = false) String startTime,
                                                                    @RequestParam(value = "endTime", required = false) String endTime,
                                                                    @RequestParam(value = "currentPage", defaultValue = "0") Integer currentPage,
                                                                    @RequestParam(value = "numPerPage", defaultValue = "1000") Integer numPerPage) {
        Map<String, Object> map = SessionUtil.getToken4Redis(token);
        String isSystem = (String) map.get(SessionUtil.IS_SYSTEM);
        Long partyId = (Long) map.get(SessionUtil.PARTY_ID);
        if (IsSystem.NOT_SYSTEM.code.equals(isSystem)) {
            partyId = (Long) map.get(SessionUtil.MEMBER_ID);
        }
        specialBookBiz.exportSpecialBook(queryName,startTime, endTime,currentPage, numPerPage, wechatUser, partyId);
        return new ResponseDto<>();
    }



}