package com.pcloud.book.book.biz.impl;

import com.pcloud.book.book.biz.BookAdviserBiz;
import com.pcloud.book.book.biz.BookRaysClassifyBiz;
import com.pcloud.book.book.dao.BookRaysClassifyDao;
import com.pcloud.book.book.dto.BookAdviserDto;
import com.pcloud.common.core.aspect.ParamLog;

import org.springframework.stereotype.Service;

import java.util.Objects;

import javax.annotation.Resource;

@Service
public class BookRaysClassifyBizImpl implements BookRaysClassifyBiz {
    @Resource
    private BookRaysClassifyDao bookRaysClassifyDao;
    @Resource
    private BookAdviserBiz bookAdviserBiz;

    @ParamLog("[根据书获取对应小睿分类id]")
    @Override
    public Long getClassifyId(Long bookId, Long adviserId, Long channelId) {
        BookAdviserDto base = bookAdviserBiz.getBase(bookId, channelId, adviserId);
        if (Objects.isNull(base)) {
            return 0L;
        }
        return this.bookRaysClassifyDao.getClassifyIdByBookTemplateId(base.getTempletId());
    }

}