package com.pcloud.book.book.biz.impl;

import com.pcloud.book.book.entity.QrcodeSceneErp;
import com.pcloud.book.book.dao.QrcodeSceneErpDao;
import com.pcloud.book.book.biz.QrcodeSceneErpBiz;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.NumberUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.List;

/**
 * ERP自动创建二维码临时表，由于没有 adviserId，所以无法创建二维码，将数据暂存，关联时再创建(QrcodeSceneErp)表服务实现类
 *
 * @author makejava
 * @since 2020-08-26 21:00:12
 */
@Service("qrcodeSceneErpBiz")
public class QrcodeSceneErpBizImpl implements QrcodeSceneErpBiz {

    private static final Logger LOGGER = LoggerFactory.getLogger(QrcodeSceneErpBizImpl.class);

    @Autowired
    private QrcodeSceneErpDao qrcodeSceneErpDao;

    @Override
    @ParamLog("通过ID查询单条数据")
    public QrcodeSceneErp getById(Long sceneErpId) {
        return qrcodeSceneErpDao.getById(sceneErpId);
    }

    @Override
    @ParamLog("查询多条数据")
    public PageBeanNew getList(Integer currentPage, Integer numPerPage) {
        PageBeanNew pageBeanNew = qrcodeSceneErpDao.listPageNew(new PageParam(currentPage, numPerPage), null, "getList");
        List recordList = pageBeanNew.getRecordList();
        if (ListUtils.isEmpty(recordList)){
            return pageBeanNew;
        }
        // 加载其它数据
        
        return pageBeanNew;
    }

    @Override
    @ParamLog("新增")
    public Long insert(QrcodeSceneErp qrcodeSceneErp) {
        qrcodeSceneErpDao.insert(qrcodeSceneErp);
        return qrcodeSceneErp.getSceneErpId();
    }

    @Override
    @ParamLog("修改")
    public void update(QrcodeSceneErp qrcodeSceneErp) {
        if(qrcodeSceneErp == null || !NumberUtil.isNumber(qrcodeSceneErp.getSceneErpId())){
            throw BizException.PARAM_IS_NULL;
        }
        qrcodeSceneErpDao.update(qrcodeSceneErp);
    }

    @Override
    @ParamLog("删除")
    public void deleteById(Long sceneErpId) {
        qrcodeSceneErpDao.deleteById(sceneErpId);
    }
}