package com.pcloud.book.book.dao;

import java.util.List;
import java.util.Map;

import com.pcloud.book.book.dto.BookFundDto;
import com.pcloud.book.book.dto.BookFundInfoDto;
import com.pcloud.book.book.entity.BookFund;
import com.pcloud.common.core.dao.BaseDao;

/**
 * @描述：书刊基金数据访问层接口
 * @作者：lihao
 * @创建时间：2017年7月14日,下午2:57:21 @版本：1.0
 */
public interface BookFundDao extends BaseDao<BookFund> {

	/**
	 * @Description:根据书籍ID获取书刊基金
	 * @param bookId
	 *            图书标识
	 * @return: List<BookFundDto>
	 * @author: lihao
	 * @date: 2017年7月19日 下午3:44:51
	 */
	List<BookFundDto> getByBookId(Long bookId);

	/**
	 * 修改基金获取不包含自己的基金列表
	 * 
	 * @param paramMap
	 * @return
	 */
	List<BookFundDto> getFundListByMap(Map<String, Object> paramMap);

	/**
	 * @Title: getByBookIds
	 * @Description:根据bookIds查询书刊基金关联信息
	 * @param bookIds
	 *            图书标识列表
	 * @return: Map<Long,BookFundDto>
	 * @author: lihao
	 * @date: 2017年7月19日 下午5:37:14
	 */
	Map<Long, BookFundDto> getByBookIds(List<Long> bookIds);

	/**
	 * @Title: getByParamMap
	 * @Description:根据参数查询书刊基金信息
	 * @param paramMap
	 * @return: List<BookFundDto>
	 * @author: lihao
	 * @date: 2017年7月21日 下午1:09:19
	 */
	List<BookFundDto> getByParamMap(Map<String, Object> paramMap);

	/**
	 * @Title: getBookFundMoney
	 * @Description:批量获取书刊基金总额
	 * @param bookIds
	 *            图书标识列表
	 * @return: Map<Long,BookFundDto>
	 * @author: lihao
	 * @date: 2017年7月21日 下午1:09:39
	 */
	Map<Long, BookFundDto> getBookFundMoney(List<Long> bookIds);

	/**
	 * @Title: getCurrentBookFund
	 * @Description://获取当前书刊基金状态
	 * @param bookId
	 *            图书标识
	 * @return: List<BookFundDto>
	 * @author: lihao
	 * @date: 2017年7月21日 下午1:08:47
	 */
	List<BookFundDto> getCurrentBookFund(Long bookId);

	/**
	 * 获取图书在基金支持的基金名称
	 * 
	 * @param paramMap
	 * @return
	 */
	String getUseFundName(Map<String, Object> paramMap);

	/**
	 * 正在基金支持的图书
	 * 
	 * @param paramMap
	 * @return
	 */
	Long getHaveFundBook(Map<String, Object> paramMap);

	/**
	 * 获取书刊基金状态
	 * 
	 * @param bookFundId
	 *            书刊基金标识
	 * @return
	 */
	BookFundDto getByBookFundId(Long bookFundId);

	/**
	 * 正在基金支持的图书列表
	 * 
	 * @param bookIds
	 *            图书标识列表
	 * @return
	 */
	List<Long> listHaveFundBooks(List<Long> bookIds);

	/**
	 * 获取所有正在基金支持的图书列表
	 * 
	 * @return
	 */
	List<Long> listAllHaveFundBooks();
	/**
	 * 获取图书在基金支持的基金信息
	 *
	 * @param paramMap
	 * @return
	 */
	BookFundInfoDto getUseFundInfo(Map<String, Object> paramMap);

	/**
	 * 获取是否是基金书
	 * @param bookId
	 * @return
	 */
    Boolean getIsHaveFundBefore(Long bookId);
    /**
     * 获取基金书数量
     * @author：zhuyajie
     * @date：2021/1/6 9:43
     *  * @param null
     */
    Integer getFundBookCount();
}
