package com.pcloud.book.book.dao;

import com.pcloud.book.book.entity.BookLink;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;
import java.util.Map;

/**
 * 编辑创建的书刊链接(BookLink)表数据库访问层
 *
 * @author makejava
 * @since 2021-04-01 09:56:29
 */
public interface BookLinkDao extends BaseDao<BookLink>{

    /**
     * 根据编辑和书刊查询书刊链接
     * @author：zhuyajie
     * @date：2021/4/1 10:06
     *  * @param null
     */
    BookLink getByBookIdAndAdviser(Long bookId, Long adviserId);

    /**
     * 查书刊链接
     * @author：zhuyajie
     * @date：2021/4/1 10:10
     *  * @param null
     */
    Map<Long,BookLink> getBookLinkMap(Long adviserId, List<Long> bookIds);
}