package com.pcloud.book.book.dao;

import com.pcloud.book.book.dto.BookMinimumSupportDTO;
import com.pcloud.book.book.entity.BookMinimumSupport;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;
import java.util.Map;

/**
 * 书刊保底支持(BookMinimumSupport)表数据库访问层
 *
 * @author makejava
 * @since 2020-12-31 16:47:21
 */
public interface BookMinimumSupportDao extends BaseDao<BookMinimumSupport>{


    /**
     * 根据书刊查询
     * @author：zhuyajie
     * @date：2021/1/4 10:24
     *  * @param null
     */
    List<BookMinimumSupportDTO> getByBookId(Long bookId);

    /**
     * 获取不包含自己的保底支持
     * @author：zhuyajie
     * @date：2021/1/4 10:58
     *  * @param null
     */
    List<BookMinimumSupportDTO> getMinimunListByMap(Map<String, Object> paramMap);
    /**
     * 最近保底支持
     * @author：zhuyajie
     * @date：2021/1/4 12:01
     *  * @param null
     */
    BookMinimumSupportDTO getInfoByBookId(Long bookId);

    /**
     * 查保底支持
     * @author：zhuyajie
     * @date：2021/1/4 14:50
     *  * @param null
     */
    List<BookMinimumSupportDTO> getByParamMap(Map<String, Object> paramMap);

    /**
     * 查书刊保底支持
     * @author：zhuyajie
     * @date：2021/1/6 13:39
     *  * @param null
     */
    List<BookMinimumSupportDTO> getByBookIds(List<Long> bookIds);
}