package com.pcloud.book.book.dao;

import com.pcloud.book.book.dto.AdviserBookInfoDTO;
import com.pcloud.book.book.entity.SearchRecord;
import com.pcloud.book.book.vo.BookSearchTopVO;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

public interface SearchRecordDao extends BaseDao<SearchRecord> {
    void deleteByWxId(String wxId);

    List<String> getRecent5WxIds(Long bookId);

    void updateUserDeleteByWxId(String wxId, Boolean userDelete);

    List<BookSearchTopVO> getBookSearchTop(Integer top);

    void updateUserDeleteByWechatUserId(Long wechatUserId, Boolean userDelete);

    Integer getBookSearchCount(String keyword);

    List<AdviserBookInfoDTO> getBookSearchIds(String keyword, Integer currentPage, Integer numPerPage);

    List<Long> getWechatUserIds(List<Long> bookIds);
}
