package com.pcloud.book.book.facade.impl;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.book.biz.BookLabelBiz;
import com.pcloud.book.book.entity.BookLabel;
import com.pcloud.book.book.enums.BookLabelAuditState;
import com.pcloud.book.book.vo.BookLabelVO;
import com.pcloud.common.core.constant.SystemCode;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.string.StringUtil;
import com.pcloud.usercenter.common.exception.BookcaseException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;



@Api("书刊标签")
@RequestMapping("bookLabel")
@RestController
public class BookLabelFacadeImpl {

    @Autowired
    private BookLabelBiz bookLabelBiz;

    @ApiOperation("申请书刊标签")
    @PostMapping("applyBookLabel")
    public ResponseDto<?> applyBookLabel(@RequestHeader("token") String token, @RequestBody @ApiParam("标签")BookLabel bookLabel) throws PermissionException {
        if (null == bookLabel || StringUtil.isEmpty(bookLabel.getName()) || null== bookLabel.getType()){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少标签名称或类型");
        }
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        String systemCode = (String) SessionUtil.getVlaue(token, SessionUtil.SYSTEM_CODE);
        bookLabel.setCreateUser(partyId);
        bookLabel.setName(bookLabel.getName().trim());
        bookLabelBiz.applyBookLabel(bookLabel,systemCode);
        return new ResponseDto<>();
    }

    @ApiOperation("书刊标签审核")
    @PostMapping("auditBookLabel")
    public ResponseDto<?> auditBookLabel(@RequestHeader("token") String token, @RequestBody @ApiParam("书刊标签") BookLabelVO bookLabelVO) throws PermissionException {
        if (null == bookLabelVO || null==bookLabelVO.getLabelId() || null==bookLabelVO.getAuditState()){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"缺少标签id或审核状态");
        }
        if (BookLabelAuditState.update_pass.code.equals(bookLabelVO.getAuditState()) &&
                (null == bookLabelVO.getType() ||StringUtil.isEmpty(bookLabelVO.getName()))){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"修改后入库缺少标签名称或类型");
        }
        String systemCode = (String) SessionUtil.getVlaue(token, SessionUtil.SYSTEM_CODE);
        if (!SystemCode.pcloud.code.equalsIgnoreCase(systemCode)){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"非平台端账号不能操作");
        }
        if (!StringUtil.isEmpty(bookLabelVO.getName())){
            bookLabelVO.setName(bookLabelVO.getName().trim());
        }
        bookLabelBiz.auditBookLabel(bookLabelVO);
        return new ResponseDto<>();
    }

    @ApiOperation("书刊标签删除")
    @GetMapping("deleteById")
    public ResponseDto<?> deleteById(@RequestHeader("token")String token, @RequestParam("labelId") @ApiParam("标签id") Long labelId) throws PermissionException {
        String systemCode = (String) SessionUtil.getVlaue(token, SessionUtil.SYSTEM_CODE);
        if (!SystemCode.pcloud.code.equalsIgnoreCase(systemCode)){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"非平台端账号不能操作");
        }
        bookLabelBiz.deleteById(labelId);
        return new ResponseDto<>();
    }

    @ApiOperation("书刊标签修改排序值")
    @GetMapping("updateLabelSeq")
    public ResponseDto<?> updateLabelSeq(
            @RequestHeader("token")String token,
            @RequestParam("labelId") @ApiParam("标签id") Long labelId,
            @RequestParam("seq") @ApiParam("标签排序值") Integer seq) throws PermissionException {
        String systemCode = (String) SessionUtil.getVlaue(token, SessionUtil.SYSTEM_CODE);
        if (!SystemCode.pcloud.code.equalsIgnoreCase(systemCode)){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"非平台端账号不能操作");
        }
        bookLabelBiz.updateLabelSeq(labelId,seq);
        return new ResponseDto<>();
    }

    @ApiOperation("审核通过的标签列表")
    @GetMapping("listAuditPassBookLabel")
    public ResponseDto<PageBeanNew<BookLabelVO>> listAuditPassBookLabel(
            @RequestHeader("token") String token,
            @RequestParam(value = "labelType", required = false) @ApiParam("标签类型：1年级，2科目，3版本，4地域") Integer labelType,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页数量")Integer numPerPage) throws PermissionException {
        String systemCode = (String) SessionUtil.getVlaue(token, SessionUtil.SYSTEM_CODE);
        if (!SystemCode.pcloud.code.equalsIgnoreCase(systemCode)){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"非平台端账号不能操作");
        }
        if (null == currentPage || null == numPerPage) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "分页参数错误");
        }
        PageBeanNew<BookLabelVO> pageBeanNew = bookLabelBiz.listAuditPassBookLabel(labelType, currentPage, numPerPage);
        return new ResponseDto<>(pageBeanNew);
    }


    @ApiOperation("标签管理列表")
    @GetMapping("listApplyBookLabel")
    public ResponseDto<PageBeanNew<BookLabelVO>> listApplyBookLabel(
            @RequestHeader("token") String token,
            @RequestParam(value = "labelType", required = false) @ApiParam("标签类型：1年级，2科目，3版本，4地域") Integer labelType,
            @RequestParam("currentPage") @ApiParam("当前页") Integer currentPage,
            @RequestParam("numPerPage") @ApiParam("每页数量")Integer numPerPage,
            @RequestParam(value = "name", required = false) @ApiParam("标签名称") String name,
            @RequestParam(value = "startTime", required = false) @ApiParam("开始时间")String startTime,
            @RequestParam(value = "endTime", required = false) @ApiParam("结束时间")String endTime,
            @RequestParam(value = "auditState", required = false) @ApiParam("审核状态（0待审核1通过2修改入库3未通过）")Integer auditState) throws PermissionException {
        String systemCode = (String) SessionUtil.getVlaue(token, SessionUtil.SYSTEM_CODE);
        if (!SystemCode.pcloud.code.equalsIgnoreCase(systemCode)){
            throw new BookBizException(BookBizException.PARAM_IS_NULL,"非平台端账号不能操作");
        }
        if (null == currentPage || null == numPerPage) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "分页参数错误");
        }
        PageBeanNew<BookLabelVO> pageBeanNew = bookLabelBiz.listApplyBookLabel(labelType, currentPage, numPerPage, name, startTime, endTime, auditState);
        return new ResponseDto<>(pageBeanNew);
    }

}
