package com.pcloud.book.book.vo;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 出版社作书数据列表-二维码信息
 *
 * @author guiq
 * @version 1.0
 * @since 2020年9月24日
 */
@Data
@ApiModel("出版社作书数据列表-二维码信息")
@JsonInclude(JsonInclude.Include.NON_NULL)
public class QrcodeInfoDto implements Serializable {

    private static final long serialVersionUID = 3951537842280735854L;

    /**
     * 印码位置
     */
    @ApiModelProperty("印码位置")
    private String locationName;

    /**
     * 二维码地址
     */
    @ApiModelProperty("二维码地址")
    private String qrcodeUrl;

}
