package com.pcloud.book.clock.dao;

import com.pcloud.book.clock.dto.BookClockInfoDTO;
import com.pcloud.book.clock.entity.BookClockInfo;
import com.pcloud.common.core.dao.BaseDao;
import com.pcloud.common.page.PageBean;
import com.pcloud.common.page.PageParam;

import java.util.List;
import java.util.Map;

/**
 * @Author: hzk
 * @Date: 2019/5/24 14:51
 * @Version 1.0
 */
public interface BookClockInfoDao extends BaseDao<BookClockInfo> {

    /**
     * 获取基本信息
     * @param bookClockInfoId
     * @return
     */
    BookClockInfoDTO getBaseInfoById(Long bookClockInfoId);

    /**
     * 修改作品/应用
     * @param paramMap
     */
    void updateBaseInfo4AppType(Map<String,Object> paramMap);

    /**
     * 修改基本信息(修改关键词)
     * @param paramMap
     */
    void updateBaseInfo4KeywordType(Map<String,Object> paramMap);

    /**
     * 获取基本信息
     * @param bookClockInfoId
     * @return
     */
    BookClockInfoDTO getBookGroupClockBaseInfo(Long bookClockInfoId);

    /**
     * 获取该编辑已选的超级作者作品及应用
     * @param adviserId
     * @return
     */
    List<BookClockInfoDTO> getOriginIdAndTypeByAdviserId(Long adviserId);

    /**
     * 获取该作品/应用该编辑创建的基本信息
     * @param paramMap
     * @return
     */
    BookClockInfoDTO getBaseInfoByMap(Map<String,Object> paramMap);

    /**
     * 获取群打卡列表
     * @param pageParam
     * @param paramMap
     * @return
     */
    PageBean listBookGroupClock(PageParam pageParam, Map<String, Object> paramMap);

    /**
     * 修改作品信息
     * @param productId
     * @param title
     * @param coverImg
     * @param uniqueNumber
     */
    void updateProductInfo(Long productId,String title,String coverImg,String uniqueNumber);

    /**
     * 修改应用信息
     * @param appId
     * @param title
     * @param coverImg
     */
    void updateAppInfo(Long appId,String title,String coverImg);

    /**
     * 删除关联的基本信息
     * @param paramMap
     */
    void deleteBookClockInfo(Map<String, Object> paramMap);

    List<BookClockInfoDTO> getAllClockInfoIds();
    List<BookClockInfoDTO> getAllAttInfoIds();
}
