package com.pcloud.book.clock.dao;

import com.pcloud.book.clock.dto.BookClockKeywordDTO;
import com.pcloud.book.clock.dto.BookGroupClockKeywordDTO;
import com.pcloud.book.clock.entity.BookClockKeyword;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;
import java.util.Map;

/**
 * @Author: hzk
 * @Date: 2019/5/27 14:19
 * @Version 1.0
 */
public interface BookClockKeywordDao extends BaseDao<BookClockKeyword> {

    /**
     * 校验关键词有无重复
     * @param paramMap
     * @return
     */
    List<Long> checkKeywordHasExist(Map<String,Object> paramMap);

    /**
     * 获取该作品/应用操作最大排序值
     * @param bookClockInfoId
     * @return
     */
    Long getMaxSequence4Keyword(Long bookClockInfoId);

    /**
     * 批量插入
     */
    void batchInsert(List<BookClockKeyword> bookClockKeywordList);

    /**
     * 删除旧的关键词
     * @param paramMap
     */
    void deleteBookClockKeyword(Map<String,Object> paramMap);

    /**
     * 获取微信打卡作品/应用关键词
     * @param paramMap
     * @return
     */
    List<BookClockKeywordDTO> getKeywordsByInfoId(Map<String,Object> paramMap);

    /**
     * 获取该关键词已关联的作品
     * @param paramMap
     * @return
     */
    List<Long> getInfoIdByKeyword(Map<String,Object> paramMap);

    /**
     * 根据接收到的关键词获取对应的作品/应用ID
     * @param paramMap
     * @return
     */
    BookClockKeywordDTO getInfoIdByKeywordAndweixinGroupId(Map<String,Object> paramMap);

    /**
     * 获取微信群打卡动作关键词
     * @param paramMap
     * @return
     */
    BookGroupClockKeywordDTO getBookClockKeyword4Clock(Map<String,Object> paramMap);
}
