package com.pcloud.book.clock.dao.impl;

import com.pcloud.book.clock.dao.BookClockKeywordDao;
import com.pcloud.book.clock.dto.BookClockKeywordDTO;
import com.pcloud.book.clock.dto.BookGroupClockKeywordDTO;
import com.pcloud.book.clock.entity.BookClockKeyword;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * @Author: hzk
 * @Date: 2019/5/27 14:21
 * @Version 1.0
 */
@Component("bookClockKeywordDao")
public class BookClockKeywordDaoImpl extends BaseDaoImpl<BookClockKeyword> implements BookClockKeywordDao {

    /**
     * 校验关键词有无重复
     * @param paramMap
     * @return
     */
    @Override
    public List<Long> checkKeywordHasExist(Map<String, Object> paramMap) {
        return super.sqlSessionTemplate.selectList(getStatement("checkKeywordHasExist"),paramMap);
    }

    /**
     * 获取该作品/应用操作最大排序值
     * @param bookClockInfoId
     * @return
     */
    @Override
    public Long getMaxSequence4Keyword(Long bookClockInfoId) {
        return super.sqlSessionTemplate.selectOne(getStatement("getMaxSequence4Keyword"),bookClockInfoId);
    }

    /**
     * 批量插入
     */
    @Override
    public void batchInsert(List<BookClockKeyword> bookClockKeywordList) {
        super.sqlSessionTemplate.insert(getStatement("batchInsert"),bookClockKeywordList);
    }

    /**
     * 删除旧的关键词
     * @param paramMap
     */
    @Override
    public void deleteBookClockKeyword(Map<String, Object> paramMap) {
        super.sqlSessionTemplate.delete(getStatement("deleteBookClockKeyword"),paramMap);
    }

    /**
     * 获取微信打卡作品/应用关键词
     * @param paramMap
     */
    @Override
    public List<BookClockKeywordDTO> getKeywordsByInfoId(Map<String,Object> paramMap) {
        return super.sqlSessionTemplate.selectList(getStatement("getKeywordsByInfoId"),paramMap);
    }

    /**
     * 获取该关键词已关联的书及分类
     * @param paramMap
     * @return
     */
    @Override
    public List<Long> getInfoIdByKeyword(Map<String, Object> paramMap) {
        return super.sqlSessionTemplate.selectList(getStatement("getInfoIdByKeyword"),paramMap);
    }

    /**
     * 根据接收到的关键词获取对应的作品/应用ID
     * @param paramMap
     * @return
     */
    @Override
    public BookClockKeywordDTO getInfoIdByKeywordAndweixinGroupId(Map<String, Object> paramMap) {
        return super.sqlSessionTemplate.selectOne(getStatement("getInfoIdByKeywordAndweixinGroupId"),paramMap);
    }

    /**
     * 获取微信群打卡动作关键词
     * @param paramMap
     * @return
     */
    @Override
    public BookGroupClockKeywordDTO getBookClockKeyword4Clock(Map<String,Object> paramMap) {
        return super.sqlSessionTemplate.selectOne(getStatement("getBookClockKeyword4Clock"),paramMap);
    }
}
