package com.pcloud.book.clock.dao.impl;

import com.pcloud.book.clock.dao.BookGroupClockDao;
import com.pcloud.book.clock.dto.BookGroupClockDTO;
import com.pcloud.book.clock.entity.BookGroupClock;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author: hzk
 * @Date: 2019/5/24 14:51
 * @Version 1.0
 */
@Repository("bookGroupClockDao")
public class BookGroupClockDaoImpl extends BaseDaoImpl<BookGroupClock> implements BookGroupClockDao {


    @Override
    public void batchInsert(List<BookGroupClock> bookGroupClockList) {
        super.sqlSessionTemplate.insert(getStatement("batchInsert"),bookGroupClockList);
    }

    /**
     * 删除关联的社群书
     * @param paramMap
     */
    @Override
    public void deleteBookGroupId4AppType(Map<String, Object> paramMap) {
        super.sqlSessionTemplate.delete(getStatement("deleteBookGroupId4AppType"),paramMap);
    }

    /**
     * 删除关联的分类
     * @param paramMap
     */
    @Override
    public void deleteClassifyId4AppType(Map<String, Object> paramMap) {
        super.sqlSessionTemplate.delete(getStatement("deleteClassifyId4AppType"),paramMap);
    }

    /**
     * 获取关联的社群码
     * @param paramMap
     * @return
     */
    @Override
    public List<BookGroupClockDTO> getBookGroupClockIds(Map<String, Object> paramMap) {
        return super.sqlSessionTemplate.selectList(getStatement("getBookGroupClockIds"),paramMap);
    }

    /**
     * 删除该作品/应用已关联的书下面的分类
     * @param paramMap
     * @return
     */
    @Override
    public void deleteClassifyIdByBookGroupIds(Map<String,Object> paramMap) {
        super.sqlSessionTemplate.delete(getStatement("deleteClassifyIdByBookGroupIds"),paramMap);
    }

    /**
     * 校验群是否为微信群打卡的群
     * @param paramMap
     * @return
     */
    @Override
    public List<Long> getInfoIdByWeixinGroupId(Map<String, Object> paramMap) {
        return super.sqlSessionTemplate.selectList(getStatement("getInfoIdByWeixinGroupId"),paramMap);
    }

    /**
     * 获取微信群打卡基本信息
     * @param bookClockInfoIds
     * @return
     */
    @Override
    public List<BookGroupClockDTO> getInfoByInfoIds(List<Long> bookClockInfoIds) {
        return super.sqlSessionTemplate.selectList(getStatement("getInfoByInfoIds"),bookClockInfoIds);
    }

    /**
     * 取消关联
     * @param paramMap
     * @return
     */
    @Override
    public void cancelSelected(Map<String, Object> paramMap) {
        super.sqlSessionTemplate.delete(getStatement("cancelSelected"),paramMap);
    }

    /**
     * 删除对应关联的书及分类
     * @param paramMap
     * @return
     */
    @Override
    public void deleteBookGroupClock(Map<String, Object> paramMap) {
        super.sqlSessionTemplate.delete(getStatement("deleteBookGroupClock"),paramMap);
    }

    @Override
    public List<Long> getClassifyIdsByBookGroupId(Long bookClockInfoId) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("bookClockInfoId",bookClockInfoId);
        return super.sqlSessionTemplate.selectList(getStatement("getClassifyIdsByBookGroupId"),paramMap);
    }

    @Override
    public List<Long> getClassifyIdsByClassfyId(Long bookClockInfoId) {
        Map<String,Object> paramMap = new HashMap<>();
        paramMap.put("bookClockInfoId",bookClockInfoId);
        return super.sqlSessionTemplate.selectList(getStatement("getClassifyIdsByClassfyId"),paramMap);
    }
}
