package com.pcloud.book.consumer.app;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.pcloud.common.core.aspect.ParamLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import com.pcloud.appcenter.assist.dto.AssistTempletDTO;
import com.pcloud.appcenter.assist.service.AssistTempletService;
import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.ResponseHandleUtil;

/**
 * 模板外部接口调用
 *
 * @author lili
 * @date 创建时间：2017年11月10日 上午11:17:39
 */
@Repository("assistTempletConsr")
public class AssistTempletConsr {
	/**
	 * logger
	 */
	private static final Logger LOGGER = LoggerFactory.getLogger(AssistTempletConsr.class);

	@Autowired
	private AssistTempletService assistTempletService;

	/**
	 * 获取模板基本信息
	 *
	 * @return
	 */
	public Map<Long, AssistTempletDTO> mapByIds(List<Long> assistTempletIds) {
		LOGGER.info("获取模板基本信息[assistTempletService.mapByIds],参数列表[assistTempletIds]:" + assistTempletIds);
		Map<Long, AssistTempletDTO> assistTempletDTOs = new HashMap<>();
		if (ListUtils.isEmpty(assistTempletIds)) {
			return assistTempletDTOs;
		}
		try {
			assistTempletDTOs = ResponseHandleUtil.parseMapResponse(assistTempletService.mapByIds(assistTempletIds),
					Long.class, AssistTempletDTO.class);
		} catch (BizException e) {
			LOGGER.warn("获取模板基本信息[assistTempletService.mapByIds]:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("获取模板基本信息[assistTempletService.mapByIds]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_APP_ERROR, "获取模板基本信息失败~!");
		}
		return assistTempletDTOs;
	}

	@ParamLog(description = "根据父项获取子项模板ID集合")
	public List<Long> getChildIdListByParentId(Long parentId){
		if(null == parentId){
			return null;
		}
		List<Long> ids = null;
		try {
			ids = ResponseHandleUtil.parseListResponse(assistTempletService.getChildIdBy(parentId),Long.class);

		} catch (BizException e) {
			LOGGER.error("获取模板基本信息[assistTempletService.mapByIds]:" + e.getMessage(), e);
		}
		return ids;
	}



	/**
	 * 获取模板基本信息
	 *
	 * @return
	 */
	public Map<Long, AssistTempletDTO> mapByIds4Classify(List<Long> assistTempletIds) {
		LOGGER.info("获取模板基本信息[assistTempletService.mapByIds4Classify],参数列表[assistTempletIds]:" + assistTempletIds);
		Map<Long, AssistTempletDTO> assistTempletDTOs = new HashMap<>();
		if (ListUtils.isEmpty(assistTempletIds)) {
			return assistTempletDTOs;
		}
		try {
			assistTempletDTOs = ResponseHandleUtil.parseMapResponse(assistTempletService.mapByIds4Classify(assistTempletIds),
					Long.class, AssistTempletDTO.class);
		} catch (BizException e) {
			LOGGER.warn("获取模板基本信息[assistTempletService.mapByIds4Classify]:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("获取模板基本信息[assistTempletService.mapByIds4Classify]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_APP_ERROR, "获取模板基本信息失败~!");
		}
		return assistTempletDTOs;
	}

	@ParamLog("查二级分类列表")
	public List<AssistTempletDTO> getChildTempletList(List<Long> parentIds){
		List<AssistTempletDTO> list = new ArrayList<>();
		try {
			list = ResponseHandleUtil.parseList(assistTempletService.getChildTempletList(parentIds),AssistTempletDTO.class);
		}catch (Exception e){
			LOGGER.error("查二级分类列表失败"+e.getMessage(),e);
		}
		return list;
	}

	@ParamLog("根据id查类型")
	public AssistTempletDTO getTempletById(Long id){
		AssistTempletDTO assistTempletDTO = null;
		try {
			assistTempletDTO = ResponseHandleUtil.parseResponse(assistTempletService.getById(id),AssistTempletDTO.class);

		}catch (Exception e){
			LOGGER.error("调用失败"+e.getMessage());
		}
		return assistTempletDTO;
	}
}
