package com.pcloud.book.copyright.biz.impl;

import com.pcloud.book.copyright.biz.BookExportRecordBiz;
import com.pcloud.book.copyright.dao.BookExportRecordDao;
import com.pcloud.book.copyright.entity.BookExportRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author lily
 * @date 2018/12/4 19:14
 */
@Component("bookExportRecordBiz")
public class BookExportRecordBizImpl implements BookExportRecordBiz {

    @Autowired
    private BookExportRecordDao bookExportRecordDao;


    @Override
    public void insertRecord(BookExportRecord bookExportRecord) {
        bookExportRecordDao.insert(bookExportRecord);
    }

    @Override
    public void updateRecordStatus(BookExportRecord bookExportRecord) {
        bookExportRecordDao.updateRecordStatus(bookExportRecord);
    }

    @Override
    public Boolean isHaveExport(Long bookId, Long channelId, Long adviserId) {
        return  bookExportRecordDao.isHaveExport(bookId, channelId, adviserId);
    }

    @Override
    public void updateRecord(BookExportRecord bookExportRecord) {
        bookExportRecordDao.updateRecord(bookExportRecord);
    }

    @Override
    public void handleExportFail() {
        bookExportRecordDao.handleExportFail();
    }
}
