package com.pcloud.book.copyright.service.impl;

import com.pcloud.book.copyright.biz.BookAuthInfoBiz;
import com.pcloud.book.copyright.biz.BookAuthUserBiz;
import com.pcloud.book.copyright.dto.BookAuthInfoCountDTO;
import com.pcloud.book.copyright.dto.BookAuthTotalCountDTO;
import com.pcloud.book.copyright.dto.CheckUserAuthDTO;
import com.pcloud.book.copyright.service.BookAuthInfoService;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ResponseHandleUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author lily
 * @date 2018/12/4 16:26
 */
@RestController("bookAuthInfoService")
@RequestMapping("bookAuthInfoService")
public class BookAuthInfoServiceImpl implements BookAuthInfoService {
    @Autowired
    private BookAuthInfoBiz bookAuthInfoBiz;
    @Autowired
    private BookAuthUserBiz bookAuthUserBiz;

    @Override
    @RequestMapping(value = "/getBookAuthPrice", method = RequestMethod.GET)
    public ResponseEntity<ResponseDto<BigDecimal>> getBookAuthPrice(@RequestParam("bookId") Long bookId,
         @RequestParam("channelId")Long channelId, @RequestParam("adviserId")Long adviserId) throws BizException {
        return ResponseHandleUtil.toResponse(bookAuthInfoBiz.getBookAuthPrice(bookId, channelId, adviserId, null));
    }

    @Override
    @RequestMapping(value = "/getBookAuthInfoCount", method = RequestMethod.GET)
    public ResponseEntity<ResponseDto<BookAuthInfoCountDTO>> getBookAuthInfoCount(@RequestParam("bookId") Long bookId, @RequestParam("channelId") Long channelId,
                                                                                  @RequestParam("adviserId") Long adviserId, @RequestParam(value = "monthDate", required = false) String monthDate) throws BizException {
        BookAuthInfoCountDTO bookAuthInfoCountDTO = bookAuthInfoBiz.getBookAuthInfoCount(bookId, channelId, adviserId, monthDate);
        return ResponseHandleUtil.toResponse(bookAuthInfoCountDTO);
    }

    @Override
    @RequestMapping(value = "/getBookAuthTotalCount", method = RequestMethod.GET)
    public ResponseEntity<ResponseDto<BookAuthTotalCountDTO>> getBookAuthTotalCount() throws BizException {
        BookAuthTotalCountDTO bookAuthTotalCountDTO = bookAuthInfoBiz.getBookAuthTotalCount(null);
        return ResponseHandleUtil.toResponse(bookAuthTotalCountDTO);
    }

    @Override
    @RequestMapping(value = "/getBookAuthTotalCount4Adviser", method = RequestMethod.POST)
    public ResponseEntity<ResponseDto<BookAuthTotalCountDTO>> getBookAuthTotalCount4Adviser(@RequestBody List<Long> adviserIds) throws BizException {
        BookAuthTotalCountDTO bookAuthTotalCountDTO = bookAuthInfoBiz.getBookAuthTotalCount(adviserIds);
        return ResponseHandleUtil.toResponse(bookAuthTotalCountDTO);
    }

    @Override
    @RequestMapping(value = "/checkUserIsHaveAuth", method = RequestMethod.POST)
    public ResponseEntity<ResponseDto<Boolean>> checkUserIsHaveAuth(@RequestBody CheckUserAuthDTO checkUserAuthDTO) throws BizException {
        return ResponseHandleUtil.toResponse(bookAuthUserBiz.checkUserIsHaveAuth(checkUserAuthDTO));
    }

    @Override
    @RequestMapping(value = "/getGroupBookAuthPrice", method = RequestMethod.GET)
    public ResponseEntity<ResponseDto<BigDecimal>> getGroupBookAuthPrice(@RequestParam("bookId") Long bookId,
                                                                    @RequestParam("channelId")Long channelId, @RequestParam("adviserId")Long adviserId) throws BizException {
        return ResponseHandleUtil.toResponse(bookAuthInfoBiz.getBookAuthPrice(bookId, channelId, adviserId, 1));
    }
}
