package com.pcloud.book.cultivate.service.impl;

import com.pcloud.book.cultivate.biz.CultivateNotifyBiz;
import com.pcloud.book.cultivate.entity.CultivateNotifySend;
import com.pcloud.book.cultivate.service.CultivateNotifyService;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;


@RestController("cultivateNotifyService")
@RequestMapping("cultivateNotifyService")
public class CultivateNotifyServiceImpl implements CultivateNotifyService {

    @Autowired
    private CultivateNotifyBiz cultivateNotifyBiz;

    @Override
    @RequestMapping(value = "/batchSendMiniUser", method = RequestMethod.POST)
    public void batchSendMiniUser(@RequestBody List<CultivateNotifySend> list) throws BizException {
        if (!ListUtils.isEmpty(list)) {
            cultivateNotifyBiz.batchSendMiniUser(list);
        }
    }
}
