package com.pcloud.book.custom.dao.impl;

import com.pcloud.book.custom.entity.CustomPlanEmail;
import com.pcloud.book.custom.dao.CustomPlanEmailDao;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;
import org.apache.ibatis.annotations.Param;
import java.util.List;

/**
 * 邮件提醒(CustomPlanEmail)表数据库访问层
 *
 * @author zyq
 * @since 2020-03-06 13:04:24
 */
@Repository("customPlanEmailDaoImpl")
public class CustomPlanEmailDaoImpl extends BaseDaoImpl<CustomPlanEmail> implements CustomPlanEmailDao {

    @Override
    public CustomPlanEmail getCustomPlanEmailByPlanId(Integer customPlanId) {
        return super.getSqlSession().selectOne(getStatement("getCustomPlanEmailByPlanId"), customPlanId);
    }
}