package com.pcloud.book.giftcoupon.dao.impl;

import com.pcloud.book.giftcoupon.dao.GiftCategoryDao;
import com.pcloud.book.giftcoupon.dto.GiftCategoryDTO;
import com.pcloud.book.giftcoupon.dto.GiftPackageDTO;
import com.pcloud.book.giftcoupon.entity.GiftCategory;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component
public class GiftCategoryDaoImpl extends BaseDaoImpl<GiftCategory> implements GiftCategoryDao {

    @Override
    public void batchCreate(List<GiftCategory> categoryList) {
        getSessionTemplate().insert(getStatement("batchCreate"), categoryList);
    }

    @Override
    public void deleteByPackageId(Long giftPackageId) {
        getSessionTemplate().delete(getStatement("deleteByPackageId"), giftPackageId);
    }

    @Override
    public List<GiftCategoryDTO> getByPackageId(Long giftPackageId) {
        return getSessionTemplate().selectList(getStatement("getByPackageId"),giftPackageId);
    }

    @Override
    public List<Long> getTemplateIds(List<Long> packageIds) {
        return getSessionTemplate().selectList(getStatement("getTemplateIds"),packageIds);
    }

    @Override
    public List<Long> getLabels(List<Long> packageIds) {
        return getSessionTemplate().selectList(getStatement("getLabels"),packageIds);
    }

    @Override
    public List<GiftCategoryDTO> getByPackageIds(List<Long> packageIds) {
        return getSessionTemplate().selectList(getStatement("getByPackageIds"),packageIds);
    }

    @Override
    public void deleteByPackageIds(List<Long> packageIds) {
        getSessionTemplate().delete(getStatement("deleteByPackageIds"),packageIds);
    }

    @Override
    public List<Long> getByParams(Map<String, Object> map) {
        return getSessionTemplate().selectList(getStatement("getByParams"),map);
    }

    @Override
    public List<Long> getOtherByParams(Map<String, Object> map) {
        return getSessionTemplate().selectList(getStatement("getOtherByParams"),map);
    }
}
