package com.pcloud.book.group.biz;

import com.pcloud.book.group.dto.BookGroupServeDTO;
import com.pcloud.book.group.entity.BookGroupServe;
import com.pcloud.book.group.entity.ResourcePage;
import com.pcloud.book.group.vo.ResourceColumnAndServeVO;
import com.pcloud.book.group.vo.ResourcePageItemVO;
import com.pcloud.book.group.vo.ResourcePageOneServe;
import com.pcloud.book.group.vo.ResourcePageVO;
import com.pcloud.book.group.vo.UpdateResourceColumnVO;
import com.pcloud.book.group.vo.UpdateResourcePageVO;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;
import java.util.Map;

/**
 * @ClassName com.pcloud.book.group.biz.ResourcePageBiz
 * @Author zhuyajie
 * @Description 自有码H5页面
 * @Date 2021/3/26 15:57
 * @Version 1.0
 **/
public interface ResourcePageBiz {


    /**
     * 更新资源页设置
     * @author：zhuyajie
     * @date：2021/3/26 17:05
     *  * @param null
     */
    Long updateResourcePage(UpdateResourcePageVO updateResourcePageVO);
    /**
     * 更新资源栏目设置
     * @author：zhuyajie
     * @date：2021/3/26 17:27
     *  * @param null
     */
    void updateResourceColumn(UpdateResourceColumnVO updateResourceColumnVO) throws BizException;

    /**
     * 根据rays码id查资源页基本配置
     * @author：zhuyajie
     * @date：2021/3/26 17:49
     *  * @param null
     */
    ResourcePageVO getResourcePageByBookGroupIdOrSceneId(Long bookGroupId, Long adviserId, Long sceneId);

    /**
     * 根据rays码id查资源页栏目及资源
     * @author：zhuyajie
     * @date：2021/3/29 11:49
     *  * @param null
     */
    List<ResourceColumnAndServeVO> getColumnAndServeListByPageId(Long resourcePageId, Boolean isWechat);
    /**
     * 根据书刊查资源页基本配置
     * @author：zhuyajie
     * @date：2021/3/30 10:25
     *  * @param null
     */
    ResourcePageVO getResourcePageByBookId(Long bookId, Long channelId, Long adviserId, Long wechatUserId);

    /**
     * 处理旧数据
     * @author：zhuyajie
     * @date：2021/3/31 11:38
     *  * @param null
     */
    void dealResource(List<Long> bookGroupIdList, List<Long> sceneIdList);
    /**
     * 栏目分页查询
     * @author：zhuyajie
     * @date：2021/3/31 19:06
     *  * @param null
     */
    PageBeanNew<ResourcePageItemVO> listPageResourcePageItem(Integer currentPage, Integer numPerPage, Long resourcePageColumnId);

    /**
     * 根据社群码id查询
     * @author：zhuyajie
     * @date：2021/4/1 15:25
     *  * @param null
     */
    ResourcePage getPageByBookGroupId(Long bookGroupId);
    /**
     * 获取栏目及资源类型
     * @author：zhuyajie
     * @date：2021/4/1 16:17
     *  * @param null
     */
    List<Map<String,Object>> getColumnAndServeTypeList();

    /**
     * 栏目上移下移
     * @author：zhuyajie
     * @date：2021/4/2 14:53
     *  * @param null
     */
    void updateColumnSeq(Long resourcePageColumnId, String moveType);
    /**
     * 删除栏目
     * @author：zhuyajie
     * @date：2021/4/2 15:14
     *  * @param null
     */
    void deleteColumnById(Long resourcePageColumnId);
    /**
     * 更新资源页和栏目
     * @author：zhuyajie
     * @date：2021/4/6 17:09
     *  * @param null
     */
    Long updateResourcePageAndColumn(UpdateResourcePageVO updateResourcePageVO);

    /**
     * 客户端根据rays码id查资源页基本配置
     * @author：zhuyajie
     * @date：2021/4/9 17:39
     *  * @param null
     */
    ResourcePageVO getResourcePageByBookGroupIdOrSceneId4Wechat(Long bookGroupId, Long wechatUserId, Long sceneId);

    /**
     * 资源数量
     * @author：zhuyajie
     * @date：2021/4/16 13:39
     *  * @param null
     */
    Integer getResourceCounts(Long bookId, Long adviserId, Long channelId);

    /**
     * 查应用作品资源
     * @author：zhuyajie
     * @date：2021/4/17 13:12
     *  * @param null
     */
    List<BookGroupServe> getServeListByBookGroupId(Long bookGroupId);
    /**
     * 批量更新资源聚合页二维码
     * @author：zhuyajie
     * @date：2021/4/20 1:14
     *  * @param null
     */
    void batchUpdateResourceQrcode(List<Long> qrcodeIdList, String qrcodeType);


    /**
     * 根据书籍id和channel获取资源配置页
     * @param adviserBookId
     * @param channelId
     * @return
     */
    ResourcePageVO getResourcePageByBookIdAndChannelId(Long adviserBookId, Long channelId);
    /**
     * 查资源配置
     * @author：zhuyajie
     * @date：2021/4/21 14:42
     *  * @param null
     */
    List<BookGroupServe> getServeListByBookGroupAndSceneIds(List<Long> bookGroupIds, List<Long> sceneIds);

    /**
     * 是否只配了一个应用/作品
     * @author：zhuyajie
     * @date：2021/4/21 15:09
     *  * @param null
     */
    ResourcePageOneServe hasOneResource(Long bookGroupId, Long sceneId);

    /**
     * 自有码配置的资源列表
     * @author：zhuyajie
     * @date：2021/4/21 17:52
     *  * @param null
     */
    Map<Long, List<BookGroupServeDTO>> mapSceneServeList(List<Long> sceneIds);
}