package com.pcloud.book.group.constant;

/**
 * @ClassName com.pcloud.book.group.constant.ResourcePageConstants
 * @Author zhuyajie
 * @Description 资源页
 * @Date 2021/4/2 14:44
 * @Version 1.0
 **/
public class ResourcePageConstants {

    /**
     * 栏目类型
     * @author：zhuyajie
     * @date：2021/3/31 15:13
     *  * @param null
     */
    public enum ColumnTypeEnum {

        APP_PRODUCT(1, "应用作品", new String[]{ServeTypeEnum.APP.getValue(), ServeTypeEnum.PRODUCT.getValue()}),
        OFFICIAL_ACCOUNT(2, "公众号", new String[]{ServeTypeEnum.OFFICIAL_ACCOUNT.getValue()}),
        BOOKLIST(3, "书单", new String[]{ServeTypeEnum.BOOKLIST.getValue(),ServeTypeEnum.ADVISER_BOOK.getValue()}),
        GROUP(4, "社群", new String[]{ServeTypeEnum.GROUP_ACTIVITY.getValue()}),
        THIRD_RESOURCE(5, "第三方资源", new String[]{ServeTypeEnum.THIRD_RESOURCE.getValue()}),
        PICTURE(6, "图片位", new String[]{ServeTypeEnum.APP.getValue(), ServeTypeEnum.PRODUCT.getValue(),
                ServeTypeEnum.GROUP_ACTIVITY.getValue(), ServeTypeEnum.THIRD_RESOURCE.getValue()});

        private Integer code;
        private String name;
        private String[] serves;

        public String[] getServes() {
            return serves;
        }

        public void setServes(String[] serves) {
            this.serves = serves;
        }

        public Integer getCode() {
            return code;
        }
        public void setCode(Integer code) {
            this.code = code;
        }

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        ColumnTypeEnum(Integer code, String name, String[] serves) {
            this.code = code;
            this.name = name;
            this.serves = serves;
        }
    }


    /**
     * @Author zhuyajie
     * @Description 资源页资源类型
     * @Date 2021/3/29 16:25
     * @Version 1.0
     **/
    public enum ServeTypeEnum {

        APP("APP", "应用"),
        PRODUCT("PRODUCT", "作品"),
        OFFICIAL_ACCOUNT("OFFICIAL_ACCOUNT", "公众号"),
        BOOKLIST("BOOKLIST", "平台书单"),
        ADVISER_BOOK("ADVISER_BOOK", "书刊"),
        GROUP_ACTIVITY("GROUP_ACTIVITY", "模板群"),
        THIRD_RESOURCE("THIRD_RESOURCE", "第三方资源");

        private String value;

        private String name;

        public String getValue() {
            return value;
        }

        public String getName() {
            return name;
        }

        ServeTypeEnum(String value, String name) {
            this.value = value;
            this.name = name;
        }

        public static String getNameByValue(String value) {
            for (ServeTypeEnum serveTypeEnum : ServeTypeEnum.values()) {
                if (value.equals(serveTypeEnum.value)) {
                    return serveTypeEnum.name;
                }
            }
            return null;
        }
    }

    /**
     * 栏目移动枚举
     */
    public enum MoveTypeEnum{

        /**
         * 向上移
         */
        MOVE_UP("UP"),
        MOVE_DOWN("DOWN");

        private String value;

        MoveTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return value;
        }
    }
}
