package com.pcloud.book.group.dao;

import com.pcloud.book.group.entity.GroupAnnouncement;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

public interface GroupAnnouncementDao extends BaseDao<GroupAnnouncement> {
    /**
     * 更新公告内容
     * @param content
     * @param id
     */
    void updateContentById(String content, Long id);

    /**
     * 根据社群码id获取已经设置过公告的微信群id集合
     * @param bookGroupId
     * @return
     */
    List<String> getHasAnnGroupIdsByBookGroupId(Long bookGroupId);

    /**
     * 根据社群码id获取
     * @param bookGroupId
     * @return
     */
    GroupAnnouncement getByGroupBookId(Long bookGroupId);

    /**
     * 根据分类id获取
     * @param classifyId
     * @return
     */
    GroupAnnouncement getByClassifyId(Long classifyId);
}
