package com.pcloud.book.group.dao;

import com.pcloud.book.group.entity.ResourcePage;
import com.pcloud.common.core.dao.BaseDao;

import java.util.Map;


/**
 * 自有码H5页面(ResourcePage)表数据库访问层
 *
 * @author makejava
 * @since 2021-03-26 15:25:28
 */
public interface ResourcePageDao extends BaseDao<ResourcePage>{



    /**
     * 根据社群书查询
     * @author：zhuyajie
     * @date：2021/3/30 10:35
     *  * @param null
     */
    ResourcePage getByBookGroupId(Long bookGroupId);

    /**
     * 根据书刊查询
     * @author：zhuyajie
     * @date：2021/3/30 10:35
     *  * @param null
     */
    ResourcePage getByBookId(Long bookId, Long channelId, Long adviserId);

    /**
     * 根据书设置小睿关闭
     * @author：zhuyajie
     * @date：2021/3/31 12:01
     *  * @param null
     */
    void setRaysCloseByBook(Map<String, Object> paramMap);

    /**
     * 修改页面更新时间
     * @author：zhuyajie
     * @date：2021/4/2 15:21
     *  * @param null
     */
    void updatePageUpdateTime(Long resourcePageId);
    /**
     * 根据二维码id查询
     * @author：zhuyajie
     * @date：2021/4/13 9:18
     *  * @param null
     */
    ResourcePage getBySceneId(Long sceneId);
}