package com.pcloud.book.group.dao;

import com.pcloud.book.group.dto.BookGroupServeDTO;
import com.pcloud.book.group.entity.BookGroupServe;
import com.pcloud.book.group.entity.ResourcePageItem;
import com.pcloud.book.group.vo.ResourcePageItemVO;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

/**
 * 自有码H5页面栏目资源详情(ResourcePageItem)表数据库访问层
 *
 * @author makejava
 * @since 2021-03-26 15:26:22
 */
public interface ResourcePageItemDao extends BaseDao<ResourcePageItem>{

    /**
     * 删除栏目下资源
     * @author：zhuyajie
     * @date：2021/3/26 15:39
     *  * @param null
     */
    void deleteByPageColumnId(Long resourcePageColumnId);
    /**
     * 查栏目资源
     * @author：zhuyajie
     * @date：2021/3/29 13:59
     *  * @param null
     */
    List<ResourcePageItemVO> getResourcePageItemByColumnId(Long resourcePageColumnId);

    /**
     * 查资源毕业资料列表
     * @author：zhuyajie
     * @date：2021/3/29 16:38
     *  * @param null
     */
    List<ResourcePageItemVO> getResourcePageItemByPageId(Long resourcePageId, Boolean isShow);

    /**
     * 查资源数
     * @author：zhuyajie
     * @date：2021/4/16 13:42
     *  * @param null
     */
    Integer getResourceCounts(Long resourcePageId);

    /**
     * 查应用作品资源
     * @author：zhuyajie
     * @date：2021/4/17 13:14
     *  * @param null
     */
    List<BookGroupServe> getServeListByBookGroupId(Long bookGroupId);

    void deleteByPageId(Long resourcePageId);

    List<BookGroupServe> getServeListByBookGroupIds(List<Long> bookGroupIds);

    /**
     * 查应用作品资源
     * @author：zhuyajie
     * @date：2021/4/21 10:11
     *  * @param null
     */
    List<BookGroupServe> getServeListBySceneIds(List<Long> sceneIds);

    /**
     * 检查是否只有一个应用/作品
     * @author：zhuyajie
     * @date：2021/4/21 15:29
     *  * @param null
     */
    ResourcePageItemVO checkOneServeItemByPageId(Long resourcePageId);
}