package com.pcloud.book.group.dao;

import com.pcloud.book.group.dto.BookWxQrcodeDTO;
import com.pcloud.book.group.dto.SyncWeixinGroupIdRequestDTO;
import com.pcloud.book.group.dto.UpdateQrDTO;
import com.pcloud.book.group.dto.WeixinQrcodeCountDTO;
import com.pcloud.book.group.dto.WeixinQrcodeDTO;
import com.pcloud.book.group.entity.WeixinQrcode;
import com.pcloud.book.group.vo.QrStatisticsVO;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;
import java.util.Map;

/**
 * @author lily
 * @date 2019/4/17 16:19
 */
public interface WeixinQrcodeDao extends BaseDao<WeixinQrcode> {

    Long countWechatGroup();
    /**
     * @Author:lili
     * @Desr:获取一个微信群
     * @Date:2019/3/12 18:04
     */
    WeixinQrcodeDTO getOneWechatGroup(Integer generation);

    /**
     * @Author:lili
     * @Desr:设置为已使用
     * @Date:2019/3/12 18:11
     */
    Integer setIsUseById(Long id);

    /**
     * @Author:lili
     * @Desr:获取二维码统计数量
     * @Date:2019/4/19 16:10
     */
    QrStatisticsVO getQrStatistics();

    /**
     * 获取依据版本分类的二维码统计数据
     * @return 依据版本分类的二维码统计数据
     */
    List<QrStatisticsVO> getQrStatisticsByVersion();

    /**
     * @Author:lili
     * @Desr:将处理中的二维码修改为处理失败
     * @Date:2019/3/7 15:21
     */
    void updateStatusToError();

    /**
     * @Author:lili
     * @Desr:按时间顺序获取未更新的二维码
     * @Date:2019/4/19 16:16
     */
    List<UpdateQrDTO> getInitialQr(int currentPage, Integer numPerPage);
    
    /**
     * @Author:lili
     * @Desr:设置未正在更新中
     * @Date:2019/4/19 16:17
     */
    void setOnUpdate(List<Long> qrIds);

    /**
     * @Author:lili
     * @Desr:更新二维码图片地址
     * @Date:2019/3/5 9:52
     */
    void updateQrUrl(UpdateQrDTO updateQrDTO);

    /**
     * @Author:lili
     * @Desr:获取所有正在处理的二维码数量
     * @Date:2019/3/7 10:55
     */
    Integer getQrOnHandleCount();

    /**
     * @Author:lili
     * @Desr:获取正在处理的二维码
     * @Date:2019/3/5 20:20
     */
    List<UpdateQrDTO> getQrOnHandle(Integer currentPage, Integer numPerPage, List<Long> ids);

    /**
     * @Author:lili
     * @Desr:更新微信群id
     * @Date:2019/4/2 15:04
     */
    void updateWeixinGroupId(Long weixinQrcodeId, String weixinGroupId);

    /**
     * @Author:lili
     * @Desr: 获取没有微信群id的二维码
     * @Date:2019/4/15 11:44
     */
    List<SyncWeixinGroupIdRequestDTO> listNoIdQrcode(List<Long> ids);

    /**
     * @Author:lili
     * @Desr:获取机器人对应二维码统计数据
     * @Date:2019/4/26 16:43
     */
    Map<Long,WeixinQrcodeCountDTO> listWeixinQrcodeCountByRobot(List<Long> robotIds);

    /**
     * @Author:lili
     * @Desr:更新二维码使用状态
     * @Date:2019/4/28 16:59
     */
    void updateUseState(Long id, Integer useState);

    /**
     * @Author:lili
     * @Desr:获取二维码总个数
     * @Date:2019/5/7 11:50
     */
    Integer getQrcodeCount();

    List<QrStatisticsVO> getQrcodeCountByVersion();

    /**
     * @Author:lili
     * @Desr:校验存在性
     * @Date:2019/5/10 12:49
     */
    Boolean checkExist(String weixinGroupId);

    /**
     * @Author:lili
     * @Desr: 更新二维码状态
     * @Date:2019/5/13 14:35
     */
    void updateState(Long weixinQrcodeId, Integer updateState);

    /**
     * 获取群信息
     * @param wechatGroupId
     * @return
     */
    WeixinQrcode getByGroupId(String wechatGroupId);

    /**
     * 分页获取可用微信群
     * @param paramMap 参数map
     * @return
     */
    List<BookWxQrcodeDTO> listAvailableGroupByPage(Map<String, Object> paramMap);

    /**
     * 分页获取人数超过10人的可用微信群
     * @param paramMap
     * @return
     */
    List<BookWxQrcodeDTO> listOver10AvailableGroupByPage(Map<String, Object> paramMap);

    Map<String, BookWxQrcodeDTO> listByWxGroupIds(List<String> wxGroupIds);

    String getVirtualIp(Integer generation);

    /**
     * 根据状态获取群数量
     */
    Integer countByState(Integer state, List<String> altIds);

    void updateGenerationMachineIp(Integer generation, String machineIp);

    List<UpdateQrDTO> listUpdateQrByGeneration(Integer generation, Integer limit);

    Integer getCanUseCount(Integer version);

    /**
     * 根据generation获取群信息 用于更新
     */
    List<UpdateQrDTO> listQrCode4Android(Integer generation, Integer num);
}
