package com.pcloud.book.group.dao.impl;

import com.pcloud.book.group.dao.ResourcePageDao;
import com.pcloud.book.group.entity.ResourcePage;
import com.pcloud.common.core.dao.BaseDaoImpl;

import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * @ClassName com.pcloud.book.group.dao.impl.ResourcePageDaoImpl
 * @Author zhuyajie
 * @Description 自有码H5页面
 * @Date 2021/3/26 15:32
 * @Version 1.0
 **/
@Component
public class ResourcePageDaoImpl extends BaseDaoImpl<ResourcePage> implements ResourcePageDao {
    @Override
    public ResourcePage getByBookGroupId(Long bookGroupId) {
        return getSessionTemplate().selectOne(getStatement("getByBookGroupId"), bookGroupId);
    }

    @Override
    public ResourcePage getByBookId(Long bookId, Long channelId, Long adviserId) {
        Map<String, Object> map = new HashMap<>();
        map.put("bookId", bookId);
        map.put("channelId", channelId);
        map.put("adviserId", adviserId);
        return getSessionTemplate().selectOne(getStatement("getByBookId"), map);
    }

    @Override
    public void setRaysCloseByBook(Map<String, Object> paramMap) {
        getSessionTemplate().update(getStatement("setRaysCloseByBook"), paramMap);
    }

    @Override
    public void updatePageUpdateTime(Long resourcePageId) {
        getSessionTemplate().update(getStatement("updatePageUpdateTime"), resourcePageId);
    }

    @Override
    public ResourcePage getBySceneId(Long sceneId) {
        return getSessionTemplate().selectOne(getStatement("getBySceneId"), sceneId);
    }
}
