package com.pcloud.book.group.dto;

import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;

import lombok.Data;

/**
 * 自动更新群人数DTO
 */
@Data
public class AutoUpdateGroupNumDTO {

    /**
     * 群id
     */
    private String wxGroupId;
    /**
     * 机器人id
     */
    private String robotId;
    /**
     * wxGroupIp
     */
    private String ip;
    /**
     * 当前触发次数
     */
    private AtomicInteger num = new AtomicInteger(1);

    /**
     * 开始更新时间（犹豫微信有延迟，所以新用户进群之后30s再次更新群人数）
     */
    private Date startTime;

    public AutoUpdateGroupNumDTO() {

    }

    public AutoUpdateGroupNumDTO(String wxGroupId, String robotId, String ip, Date startTime) {
        this.wxGroupId = wxGroupId;
        this.robotId = robotId;
        this.ip = ip;
        this.num = new AtomicInteger(1);
        this.startTime = startTime;
    }
}
