package com.pcloud.book.group.dto;

import com.fasterxml.jackson.annotation.JsonInclude;

import java.io.Serializable;
import java.math.BigDecimal;

import io.swagger.annotations.ApiModel;

/**
 * @author lily
 * @date 2019/4/17 14:17
 */
@ApiModel
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ClassifyDTO implements Serializable {

    /**
     * 群标签标识
     */
    private Long id;

    /**
     * 图书标识
     */
    private Long bookId;

    /**
     * 运营标识
     */
    private Long channelId;

    /**
     * 社群二维码标识
     */
    private Long bookGroupId;

    /**
     * 社群二维码标题
     */
    private String bookGroupName;

    /**
     * 分类
     */
    private String classify;

    /**
     * 书籍名称
     */
    private String bookName;

    /**
     * 分类介绍
     */
    private String classifyIntroduce;

    /**
     * 价格
     */
    private BigDecimal price;

    /**
     * 商品标识
     */
    private Long productId;

    /**
     * 规格标识
     */
    private Long productSpecId;

    /**
     * 换群人数
     */
    private Integer changeNumber;

    /**
     * 排序
     */
    private Integer rank;

    private Long bookClockInfoId;

    private Long createUser;

    public Integer getRank() {
        return rank;
    }

    public void setRank(Integer rank) {
        this.rank = rank;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getClassify() {
        return classify;
    }

    public void setClassify(String classify) {
        this.classify = classify;
    }

    public String getBookName() {
        return bookName;
    }

    public void setBookName(String bookName) {
        this.bookName = bookName;
    }

    public String getClassifyIntroduce() {
        return classifyIntroduce;
    }

    public void setClassifyIntroduce(String classifyIntroduce) {
        this.classifyIntroduce = classifyIntroduce;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Integer getChangeNumber() {
        return changeNumber;
    }

    public void setChangeNumber(Integer changeNumber) {
        this.changeNumber = changeNumber;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public Long getBookGroupId() {
        return bookGroupId;
    }

    public void setBookGroupId(Long bookGroupId) {
        this.bookGroupId = bookGroupId;
    }

    public Long getProductId() {
        return productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }

    public Long getProductSpecId() {
        return productSpecId;
    }

    public void setProductSpecId(Long productSpecId) {
        this.productSpecId = productSpecId;
    }

    public String getBookGroupName() {
        return bookGroupName;
    }

    public void setBookGroupName(String bookGroupName) {
        this.bookGroupName = bookGroupName;
    }

    public Long getBookClockInfoId() {
        return bookClockInfoId;
    }

    public void setBookClockInfoId(Long bookClockInfoId) {
        this.bookClockInfoId = bookClockInfoId;
    }

    public Long getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Long createUser) {
        this.createUser = createUser;
    }

    @Override
    public String toString() {
        return "ClassifyDTO{" +
                "id=" + id +
                ", bookId=" + bookId +
                ", channelId=" + channelId +
                ", bookGroupId=" + bookGroupId +
                ", bookGroupName='" + bookGroupName + '\'' +
                ", classify='" + classify + '\'' +
                ", bookName='" + bookName + '\'' +
                ", classifyIntroduce='" + classifyIntroduce + '\'' +
                ", price=" + price +
                ", productId=" + productId +
                ", productSpecId=" + productSpecId +
                ", changeNumber=" + changeNumber +
                ", rank=" + rank +
                ", bookClockInfoId=" + bookClockInfoId +
                ", createUser=" + createUser +
                '}';
    }
}
