package com.pcloud.book.group.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.math.BigDecimal;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author 杨涛
 * @description 商城用户已购买的社群码dto
 * @date 2019/8/9 10:30
 */
@ApiModel("商城用户已购买的社群码dto")
@JsonInclude(JsonInclude.Include.NON_NULL)
public class GroupStoreMyPayDto {

    @ApiModelProperty("标识(appId/productId/bookGroupId)")
    private Long originId;

    @ApiModelProperty("类型(APP/PRODUCT/BOOK_GROUP)")
    private String originType;

    @ApiModelProperty("标题")
    private String originName;

    @ApiModelProperty("封面图片")
    private String coverImg;

    @ApiModelProperty("已经购买的资源数量")
    private Integer resourceNum;

    @ApiModelProperty("已经购买的资源数量")
    private Integer resourceItemNum;

    public Long getOriginId() {
        return originId;
    }

    public void setOriginId(Long originId) {
        this.originId = originId;
    }

    public String getOriginType() {
        return originType;
    }

    public void setOriginType(String originType) {
        this.originType = originType;
    }

    public String getOriginName() {
        return originName;
    }

    public void setOriginName(String originName) {
        this.originName = originName;
    }

    public String getCoverImg() {
        return coverImg;
    }

    public void setCoverImg(String coverImg) {
        this.coverImg = coverImg;
    }

    public Integer getResourceNum() {
        return resourceNum;
    }

    public void setResourceNum(Integer resourceNum) {
        this.resourceNum = resourceNum;
    }

    public Integer getResourceItemNum() {
        return resourceItemNum;
    }

    public void setResourceItemNum(Integer resourceItemNum) {
        this.resourceItemNum = resourceItemNum;
    }

    @Override
    public String toString() {
        return "GroupStoreMyPayDto{" +
                "originId=" + originId +
                ", originType='" + originType + '\'' +
                ", originName='" + originName + '\'' +
                ", coverImg='" + coverImg + '\'' +
                ", resourceNum=" + resourceNum +
                ", resourceItemNum=" + resourceItemNum +
                '}';
    }
}
