package com.pcloud.book.group.dto;

import org.springframework.beans.factory.annotation.Value;

import java.util.List;

import javax.ws.rs.DefaultValue;

import feign.Client.Default;
import lombok.Data;

/**
 * @描述：用户筛选入参
 * @作者：zhuyajie
 * @创建时间：14:51 2019/11/26
 * @版本：1.0
 */
@Data
public class UserSelectParamDTO {

    /**
     *当前页
     */
    private Integer currentPage;
    /**
     *每页数量
     */
    private Integer numPerPage;

    /**
     *小号id
     */
    private String robotId;
    /**
     *用户昵称或微信id查询
     */
    private String userQuery;
    /**
     *图书id
     */
    private List<Long> bookIds;

    /**
     * 专业标签id
     */
    private Long proLabelId;
    /**
     * 深度标签id
     */
    private Long depLabelId;

    /**
     * 单本图书id
     */
    private Long bookGroupId;

    /**
     * 不展示活动已邀请的读者-共读活动
     */
    private Boolean invitedFilter;

    /**
     * 个人号类型  1 微信 2 qq
     */
    private Integer groupRobotType;
}
