package com.pcloud.book.group.facade;

import com.pcloud.book.group.entity.CopyCipherRecord;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Api(description = "点击复制暗号记录接口")
public interface CopyCipherRecordFacade {

    @ApiOperation("新增点击复制暗号记录")
    @PostMapping("createCopyCipherRecord")
    ResponseDto<?> createCopyCipherRecord(
            @CookieValue("userInfo") String userInfo,
            @RequestBody @ApiParam("点击复制暗号记录模型") CopyCipherRecord copyCipherRecord
    ) throws BizException;

}
