package com.pcloud.book.group.facade.impl;

import com.pcloud.book.group.biz.ResourcePageBiz;
import com.pcloud.book.group.vo.UpdateResourceColumnVO;
import com.pcloud.book.group.vo.UpdateResourcePageVO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.utils.SessionUtil;
import com.pcloud.common.utils.cookie.Cookie;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

import io.swagger.annotations.ApiOperation;

/**
 * @ClassName com.pcloud.book.group.facade.impl.ResourcePageFacade
 * @Author zhuyajie
 * @Description H5资源页配置
 * @Date 2021/3/29 10:41
 * @Version 1.0
 **/
@RestController
@RequestMapping("resourcePage")
public class ResourcePageFacade {
    @Autowired
    private ResourcePageBiz resourcePageBiz;

    @ApiOperation("更新资源页基本设置")
    @PostMapping("updateResourcePage")
    public ResponseDto<?> updateResourcePage(@RequestHeader("token") String token,
                                             @RequestBody @Validated UpdateResourcePageVO updateResourcePageVO) {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        updateResourcePageVO.setCreateUser(adviserId);
        return new ResponseDto<>(resourcePageBiz.updateResourcePage(updateResourcePageVO));
    }

    @ApiOperation("更新资源栏目设置")
    @PostMapping("updateResourceColumn")
    public ResponseDto<?> updateResourceColumn(@RequestHeader("token") String token,
                                               @RequestBody @Validated UpdateResourceColumnVO updateResourceColumnVO){
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        updateResourceColumnVO.setCreateUser(adviserId);
        resourcePageBiz.updateResourceColumn(updateResourceColumnVO);
        return new ResponseDto<>();
    }

    @ApiOperation("根据rays码id查资源页基本配置")
    @GetMapping("getResourcePageByBookGroupId")
    public ResponseDto<?> getResourcePageByBookGroupId(@RequestHeader("token") String token,
                                                       @RequestParam(value = "bookGroupId", required = false) Long bookGroupId,
                                                       @RequestParam(value = "sceneId", required = false) Long sceneId){
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(resourcePageBiz.getResourcePageByBookGroupIdOrSceneId(bookGroupId, adviserId, sceneId));
    }

    @ApiOperation("编辑端-根据页面id查资源页栏目及资源")
    @GetMapping("getColumnAndServeListByPageId")
    public ResponseDto<?> getColumnAndServeListByPageId(@RequestHeader("token") String token,
                                                        @RequestParam("resourcePageId") Long resourcePageId){
        SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        return new ResponseDto<>(resourcePageBiz.getColumnAndServeListByPageId(resourcePageId, false));
    }

    @ApiOperation("客户端-根据书刊查资源页基本配置")
    @GetMapping("getResourcePageByBookId4Wechat")
    public ResponseDto<?> getResourcePageByBookId4Wechat(@CookieValue("userInfo") String userInfo,
                                                         @RequestParam("bookId") Long bookId,
                                                         @RequestParam("channelId") Long channelId,
                                                         @RequestParam("adviserId") Long adviserId){
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(resourcePageBiz.getResourcePageByBookId(bookId, channelId, adviserId, wechatUserId));
    }

    @ApiOperation("客户端-根据页面id查资源页栏目及资源")
    @GetMapping("getColumnAndServeListByPageId4Wechat")
    public ResponseDto<?> getColumnAndServeListByPageId4Wechat(@CookieValue("userInfo") String userInfo,
                                                                @RequestParam("resourcePageId") Long resourcePageId){
        Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(resourcePageBiz.getColumnAndServeListByPageId(resourcePageId, true));
    }

    @ApiOperation("客户端分页查栏目资源")
    @GetMapping("listPageResourcePageItem")
    public ResponseDto<?> listPageResourcePageItem(@CookieValue("userInfo") String userInfo,
                                                   @RequestParam("currentPage") Integer currentPage,
                                                   @RequestParam("numPerPage") Integer numPerPage,
                                                   @RequestParam("resourcePageColumnId") Long resourcePageColumnId) {
        Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(resourcePageBiz.listPageResourcePageItem(currentPage, numPerPage, resourcePageColumnId));
    }

    @ApiOperation("获取栏目及资源类型")
    @GetMapping("getColumnAndServeTypeList")
    public ResponseDto<?> getColumnAndServeTypeList() {
        return new ResponseDto<>(resourcePageBiz.getColumnAndServeTypeList());
    }

    @ApiOperation("编辑端-栏目上移下移")
    @GetMapping("updateColumnSeq")
    public ResponseDto<?> updateColumnSeq(@RequestHeader("token") String token,
                                          @RequestParam("resourcePageColumnId") Long resourcePageColumnId,
                                          @RequestParam("moveType") String moveType) {
        SessionUtil.getToken4Redis(token);
        resourcePageBiz.updateColumnSeq(resourcePageColumnId, moveType);
        return new ResponseDto<>();
    }

    @ApiOperation("编辑端-删除栏目")
    @GetMapping("deleteColumnById")
    public ResponseDto<?> deleteColumnById(@RequestHeader("token") String token,
                                           @RequestParam("resourcePageColumnId") Long resourcePageColumnId) {
        SessionUtil.getToken4Redis(token);
        resourcePageBiz.deleteColumnById(resourcePageColumnId);
        return new ResponseDto<>();
    }

    @ApiOperation("处理旧数据")
    @PostMapping("dealResource")
    public ResponseDto<?> dealResource(@RequestBody List<Long> qrcodeIdList, @RequestParam("qrcodeType") String qrcodeType){
        if ("bookgroup".equals(qrcodeType)) {
            resourcePageBiz.dealResource(qrcodeIdList, null);
        } else {
            resourcePageBiz.dealResource(null, qrcodeIdList);
        }
        return new ResponseDto<>();
    }

    @ApiOperation("更新资源页和栏目设置")
    @PostMapping("updateResourcePageAndColumn")
    public ResponseDto<?> updateResourcePageAndColumn(@RequestHeader("token") String token,
                                             @RequestBody @Validated UpdateResourcePageVO updateResourcePageVO) {
        Long adviserId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        updateResourcePageVO.setCreateUser(adviserId);
        return new ResponseDto<>(resourcePageBiz.updateResourcePageAndColumn(updateResourcePageVO));
    }

    @ApiOperation("客户端-根据rays码id查资源页基本配置")
    @GetMapping("getResourcePageByBookGroupId4Wechat")
    public ResponseDto<?> getResourcePageByBookGroupId4Wechat(@CookieValue("userInfo") String userInfo,
                                                              @RequestParam(value = "bookGroupId", required = false) Long bookGroupId,
                                                              @RequestParam(value = "sceneId", required = false) Long sceneId){
        Long wechatUserId = Cookie.getId(userInfo,Cookie._WECHAT_USER_ID);
        return new ResponseDto<>(resourcePageBiz.getResourcePageByBookGroupIdOrSceneId4Wechat(bookGroupId, wechatUserId, sceneId));
    }

    @ApiOperation("批量更新资源页二维码")
    @PostMapping("batchUpdateResourceQrcode")
    public ResponseDto<?> batchUpdateResourceQrcode(@RequestBody List<Long> qrcodeIdList, @RequestParam("qrcodeType") String qrcodeType) {
        resourcePageBiz.batchUpdateResourceQrcode(qrcodeIdList, qrcodeType);
        return new ResponseDto<>();
    }

    @ApiOperation("是否只有一个资源")
    @GetMapping("hasOneResource")
    public ResponseDto<?> hasOneResource(@RequestParam(value = "bookGroupId", required = false) Long bookGroupId,
                                          @RequestParam(value = "sceneId", required = false) Long sceneId) {
        return new ResponseDto<>(resourcePageBiz.hasOneResource(bookGroupId, sceneId));
    }
}
