package com.pcloud.book.group.mapper;

import com.pcloud.book.group.dto.UpdateGroupMaterialDTO;
import com.pcloud.book.group.entity.BizMaterial;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 业务素材与微信素材对照表(BizMaterial)表数据库访问层
 *
 * @author makejava
 * @since 2020-07-31 16:34:30
 */
@Mapper
@Component
public interface BizMaterialMapper {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    BizMaterial queryById(Long id);

    /**
     * 查询指定行数据
     *
     * @param offset 查询起始位置
     * @param limit  查询条数
     * @return 对象列表
     */
    List<BizMaterial> queryAllByLimit(@Param("offset") int offset, @Param("limit") int limit);


    /**
     * 通过实体作为筛选条件查询
     *
     * @param bizMaterial 实例对象
     * @return 对象列表
     */
    List<BizMaterial> queryAll(BizMaterial bizMaterial);

    /**
     * 新增数据
     *
     * @param bizMaterial 实例对象
     * @return 影响行数
     */
    int insert(BizMaterial bizMaterial);

    /**
     * 修改数据
     *
     * @param bizMaterial 实例对象
     * @return 影响行数
     */
    int update(BizMaterial bizMaterial);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    int deleteById(Long id);

    void batchInsert(@Param("list") List<BizMaterial> bizMaterials);

    List<UpdateGroupMaterialDTO> listBizMaterialsByGroupId(@Param("list") List<String> groups);

    /**
     * 插入或者更新
     */
    void insertOrUpdate(BizMaterial bizMaterial);

    String selectMaterialUrl4Biz(@Param("bizId") Long bizId, @Param("bizType") Integer bizType);

    BizMaterial getByBizId(@Param("bizId") Integer bizId, @Param("bizType") Integer bizType);
}