package com.pcloud.book.group.service.impl;

import com.pcloud.book.group.dto.ReplyMsgDTO;
import com.pcloud.book.group.service.WxWorkKeyWordService;
import com.pcloud.book.keywords.biz.BookKeywordBiz;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.utils.ResponseHandleUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * TODO
 *
 * @author guiq
 * @version 1.0
 * @since 2020/12/9
 */
@RestController
@RequestMapping("/wxWorkKeyWordService")
public class WxWorkKeyWordServiceImpl implements WxWorkKeyWordService {

    @Autowired
    private BookKeywordBiz bookKeywordBiz;


    @Override
    @GetMapping("/getKeyWordsByBookGroupId")
    public ResponseEntity<ResponseDto<List<ReplyMsgDTO>>> getKeyWordsByBookGroupId(@RequestParam("bookGroupId") Long bookGroupId) {
        return ResponseHandleUtil.toResponse(bookKeywordBiz.getKeyWordsByBookGroupId(bookGroupId));
    }
}
